% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_parse_json.R
\name{mp_parse_json}
\alias{mp_parse_json}
\alias{mp_parse_gtm}
\alias{mp_pubsub}
\title{Parse out objects into the Measurement Protocol v2 format for sending}
\usage{
mp_parse_json(
  json,
  name_f,
  params_f = NULL,
  items_f = NULL,
  client_id_f = NULL,
  user_id_f = NULL,
  user_properties_f = NULL
)

mp_parse_gtm(json)

mp_pubsub(pubsub_body)
}
\arguments{
\item{json}{The location of a json file or a json string or an R list that has been parsed from json via \code{jsonlite::fromJSON}}

\item{name_f}{The function that extracts the event name out of \code{json}}

\item{params_f}{An optional function that extracts parameters for the event from \code{json}}

\item{items_f}{An optional function that extracts e-commerce items from \code{json}. Must return a \link{mp_event_item} object.  you may not need this if the \code{params_f} includes parsing of e-commerce items}

\item{client_id_f}{An optional function to extract the client.id.  You will need to supply cid though if using downstream in \code{mp_send} so it usually is necessary}

\item{user_id_f}{Optionally include a function that will parse out user_id}

\item{user_properties_f}{Optionally include a function that will parse out user properties}

\item{pubsub_body}{The req$postBody of a plumber request}
}
\value{
An \code{mp_parse_json} object that is a list of an \code{mp_event} object, and \code{user} fields including client.id, user.id and user properties

The Pub/Sub message "data" attribute unencoded into a json string
}
\description{
This function helps take HTTP events and rearranges its structure so it will work in a MP measurement protocol hit.  This enables HTTP events from say Pub/Sub to be translated into MP hits.
}
\details{
The passed in functions should return NULL if they don't find any entries
}
\examples{

demo_json <- system.file("example", "pubsub-ga4.json", package = "measurementProtocol")
demo_list <- jsonlite::fromJSON(demo_json)


# extract the event_name
name_f <- function(x) x[["event_name"]]

# extract client_id
client_id_f <- function(x) x[["client_id"]]

# extract user_id
user_id_f <- function(x) x[["user_id"]]

# simple event
mp_parse_json(demo_list,
              name_f,
              client_id_f = client_id_f,
              user_id_f = user_id_f)

# params could be assumed to be everything not a event_name of client_id
# also not allowed any starting with reserved 'ga_'
params_f <- function(x){
  x_names <- names(x)[grepl("^x-", names(x))]
  ga_names <- names(x)[grepl("^ga_", names(x))]
  x[setdiff(names(x), c("client_id","user_id" ,"event_name", x_names, ga_names))]
  }

# parse including params (could include items as well)
parsed_event <- mp_parse_json(demo_list,
                              name_f,
                              params_f = params_f,
                              client_id_f = client_id_f,
                              user_id_f = user_id_f)
parsed_event

# sending to a debug endpoint
# preferably set this in .Renviron
Sys.setenv(MP_SECRET="MY_SECRET")

# replace with your GA4 settings
my_measurement_id <- "G-1234"
my_connection <- mp_connection(my_measurement_id)
mp_send(parsed_event$mp_event,
        client_id = parsed_event$user$client_id,
        user_id = parsed_event$user$user_id,
        user_properties = parsed_event$user$user_properties,
        connection = my_connection,
        debug_call = TRUE)



# mp_parse_gtm internally uses functions demonstrated with mp_parse_json
pubsub_event <- mp_parse_gtm(demo_json)

mp_send(pubsub_event$mp_event,
        client_id = pubsub_event$user$client_id,
        user_id = pubsub_event$user$user_id,
        user_properties = pubsub_event$user$user_properties,
        connection = my_connection,
        debug_call = TRUE)

\dontrun{

#* Send forward a measurement protocol hit
#* @post /gtm
#* @serializer unboxedJSON
#* @parser json
function(req, res, ga_id) {

  pubsub_data <- mp_pubsub_parse(req$postBody)

  parsed <- mp_parse_gtm(pubsub_data)

  my_connection <- mp_connection(ga_id)

  mp_send(parsed$mp_event,
          client_id = parsed$user$client_id,
          user_id = parsed$user$user_id,
          user_properties = parsed$user$user_properties,
          connection = my_connection)

  "OK"
  }


}
}
