% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_trackme.R
\name{mp_trackme}
\alias{mp_trackme}
\alias{mp_trackme_event}
\title{Opt in or out of package usage tracking}
\usage{
mp_trackme(package)

mp_trackme_event(
  package,
  debug_call = FALSE,
  say_hello = NULL,
  opt_in_function = NULL
)
}
\arguments{
\item{package}{The package name}

\item{debug_call}{Set as a debug event to see what would be sent}

\item{say_hello}{If you want to add your own custom message to the event sent, add it here!}

\item{opt_in_function}{The name of the function for a user to opt-in}
}
\value{
No return value, called for side effects
}
\description{
You can opt-in or out to sending a measurement protocol hit when you load the package for use in the package's statistics via this function.  No personal data is collected.

If you opt in, this is the function that fires.  You can use \code{debug_call=TRUE} to see what would be sent before opting in or out.
}
\details{
Running this function will send a Measurement Protocol hit via \link{mp_send} only if the cache file is present
}
\examples{

# control your tracking choices via a menu if in interactive session
if(interactive()){
  mp_trackme()
}

# this only works with a valid opt-in file present
mp_trackme_event("googleAnalyticsR")

# see what data is sent
mp_trackme_event("googleAnalyticsR", debug_call=TRUE)

# add your own message!
mp_trackme_event("googleAnalyticsR",
                 debug_call = TRUE,
                 say_hello = "err hello Mark")

# placed in .onAttach with function name
.onAttach <- function(libname, pkgname){
  measurementProtocol::mp_trackme_event(pkgname, opt_in_function = "mp_opt_in")
 }

}
