% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vat_ext}
\alias{vat_ext}
\title{Visceral adipose tissue external data [external covariate-validation study]}
\format{
A data frame with 100 rows and 5 variables:
\describe{
  \item{wc}{Waist circumference (standardised, cm)}
  \item{vat}{Visceral adipose tissue (standardised, cm^2)}
  \item{sex}{Sex (0 = male, 1 = female)}
  \item{age}{Age (years)}
  \item{tbf}{Total body fat (standardised, \%)}
}
}
\usage{
vat_ext
}
\description{
Waist circumference, visceral adipose tissue, sex, age, and total body fat of 100 individuals
}
\details{
This is a simulated data set accompanying the dataset "vat", that is inspired by the NEO data <doi:10.1007/s10654-013-9801-3>. A motivating example using the example data can be found here: <doi:10.1093/aje/kwab114>
}
\examples{
data("vat_ext", package = "mecor")
}
\references{
Renee de Mutsert, Martin den Heijer, Ton J Rabelink, Johannes WA Smit, Johannes A Romijn, Johan W Jukema, Albert de Roos, Christa M Cobbaert, Margreet Kloppenburg, Saskia le Cessie, Saskia Middeldorp, Frits R Rosendaal. The Netherlands epidemiology of obesity (NEO) study: Study design and data collection. European Journal of Epidemiology (2013). <doi:10.1007/s10654-013-9801-3>

Linda Nab, Maarten van Smeden, Renee de Mutsert, Frits R Rosendaal, and Rolf HH Groenwold. Sampling strategies for internal validation samples for exposure measurement error correction: A study of visceral adipose tissue measures replaced by waist circumference measures. American Journal of Epidemiology (2021). <doi:10.1093/aje/kwab114>
}
\keyword{datasets}
