% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rockOptimization.R
\name{utils_rockOptimization}
\alias{utils_rockOptimization}
\title{Optimization of rock fragment content}
\usage{
utils_rockOptimization(
  x,
  soil,
  SpParams,
  control,
  meteo,
  PLCquantile = 0.9,
  qPLC_target = 12,
  qPLC_tol = 0.5,
  sew_min = 30,
  max_rocks = 99,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link[medfate]{forest}}.}

\item{soil}{An object of class \code{\link{data.frame}} or \code{\link[medfate]{soil}}, containing soil parameters per soil layer.}

\item{SpParams}{A data frame with species parameters (see \code{\link[medfate]{SpParamsDefinition}} and \code{\link[medfate]{SpParamsMED}}).}

\item{control}{A list with default control parameters (see \code{\link[medfate]{defaultControl}}).}

\item{meteo}{A data frame with daily meteorological data series (see \code{\link[medfate]{spwb}}).}

\item{PLCquantile}{Maximum PLC quantile to be calculated across years.}

\item{qPLC_target}{Target PLC to be achieved (by default 12\%).}

\item{qPLC_tol}{Tolerance of PLC difference to target accepted when finding solution.}

\item{sew_min}{Minimum soil extractable water (mm) for rock exploration.}

\item{max_rocks}{Maximum content in coarse fragments allowed for any soil layer.}

\item{verbose}{A logical value. Print the internal messages of the function?}

\item{...}{Additional parameters to function \code{\link[medfate]{spwb}}.}
}
\value{
Function \code{utils_rockOptimization} returns a list containing:
\itemize{
\item{\code{RFC}: A vector with the estimated rock fragment content for each soil layer.}
\item{\code{SEW}: Soil extractable water (mm).}
\item{\code{runs}: Number of simulations performed.}
\item{\code{message}: Text message indicating whether optimization could be done (OK) or not.}
}
}
\description{
Function \code{utils_rockOptimization} finds optimum rock fragment content in the soil
corresponding to given vegetation, weather and target percent loss
of conductance (PLC), following a modification of the method proposed by Druel et al. (2023).
}
\details{
The function performs a model inversion based on an ecohydrological assumption,
consisting in that forest leaf area index is in equilibrium with a low embolism
rate under normal conditions. This is translated in that the (by default 90\%) interannual quantile of
the maximum annual percent loss of conductance (PLC), averaged over plant cohorts,
should be close to a target PLC value (by default 12\%).

The algorithm first determines the PLC corresponding to the minimum and maximum soil extractable water (SEW).
The minimum SEW (SEW_min) is an input parameter, whereas the maximum SEW (SEW_max) corresponds to no rock fragments in the soil.

Then three situations are distinguished:
\enumerate{
\item{If \code{PLC(SEW_min) < qPLC_target}  and \code{PLC(SEW_max) < qPLC_target}, the function will use \code{\link{uniroot}} to find the root
of the function \code{f(x) = PLC(x) - qPLC_target}, where \code{x} is SEW, which corresponds to a factor that multiplies the original rock fragment content.}
\item{If both \code{PLC(SEW_min) < qPLC_target} and \code{PLC(SEW_max) < qPLC_target}, the function cannot find an optimum, because PLC is always too low, and will return the original rock fragment content}
\item{Analogously, if both \code{PLC(SEW_min) > qPLC_target} and \code{PLC(SEW_max) > qPLC_target}, the function cannot find an optimum, because PLC is always too large, and will return the original rock fragment content}
}
}
\examples{
\donttest{
#Load example daily meteorological data
data(examplemeteo)

#Load example plot plant data
data(exampleforest)

#Default species parameterization
data(SpParamsMED)

#Initialize soil with two layers
examplesoil <- defaultSoilParams(4)

#Rock fragment content optimization (Granier)
utils_rockOptimization(exampleforest, soil = examplesoil,
                       SpParams = SpParamsMED, meteo = examplemeteo,
                       control = defaultControl("Granier"),
                       elevation = 100, latitude = 41.82592)
}
}
\references{
Druel, A., Martins, N., Cochard, H., De Caceres, M., Delzon, S., Mencuccini, M., Torres-Ruiz, J., and Ruffault, J.: European forest vulnerability to hydraulic failure: an ecohydrological approach, EGU General Assembly 2023, Vienna, Austria, 24–28 Apr 2023, EGU23-17068, https://doi.org/10.5194/egusphere-egu23-17068, 2023.
}
\seealso{
\code{\link{spwb}}, \code{\link{soil}}, \code{\link{utils_ldrOptimization}}
}
\author{
\enc{Arsène}{Arsene} Druel, URFM-INRAE

Nicolas Martin-StPaul, URFM-INRAE

Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
