% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMemory.R
\name{plotMemory}
\alias{plotMemory}
\title{Plots output of \code{\link{computeMemory}}}
\usage{
plotMemory(
  memory.output = NULL,
  title = "Ecological memory pattern",
  legend.position = "right",
  filename = NULL
)
}
\arguments{
\item{memory.output}{a dataframe with one time series per column.}

\item{title}{character string, name of the numeric column to be used as response in the model.}

\item{legend.position}{character vector, names of the numeric columns to be used as predictors in the model.}

\item{filename}{character string, name of output pdf file. If NULL or empty, no pdf is produced. It shouldn't include the extension of the output file.}
}
\value{
A ggplot object.
}
\description{
Plots the ecological memory pattern yielded by \code{\link{computeMemory}}.
}
\examples{
#loading data
data(palaeodataMemory)

#plotting memory pattern
plotMemory(memory.output = palaeodataMemory)


}
\seealso{
\code{\link{computeMemory}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
