% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emit_error.R
\name{emit_error}
\alias{emit_error}
\title{Stop function and provide associated messages}
\usage{
emit_error(..., .format = NULL, .f_name = TRUE, .issue = TRUE)
}
\arguments{
\item{...}{a collection of string expressions
and named arguments for string interpolation.
Bare strings will be pasted together and
separated by newlines. Named arguments are
used to provide values for string interpolation
in the message.}

\item{.format}{a format template for a
message. If not provided, the default template
of \code{"{.f_name}: {text}"} will be used.}

\item{.f_name}{the name of the function that
caused the error. If not provided, the
function name will be obtained from the
function call stack.}

\item{.issue}{a logical value that indicates
whether an error should be issued at all.}
}
\description{
Stop the execution of the function in the
parent environment and use a message body that
can be formed from multiple text objects.
If a single text object is provided then the
warning message text will appear on a single
line. If multiple text fragments are provided
then they will be separated by newlines (in
the order provided). Custom formatting is
possible by providing a messaging template
that uses the string expression scheme used
in the \code{glue} package.
}
\examples{
\dontrun{
# Write a function that stops the function
# with a message with the requested number
# of info lines
yield_an_error <- function(msgs) {

  if (msgs > 3) msgs <- 3

  # Create some strings can serve as additional
  # info for the message
  message_components <-
    c("* message info 1",
      "* message info 2",
      "* message info 3")

  # Generate and emit a formatted message
  emit_error(
    "There (is/are) {number} thing(s) to note",
    message_components[1:msgs],
    number = msgs,
    .format = "{.f_name} info: {text}")
}

# When that function is called, a formatted
# message will appear; here are some examples:
yield_an_error(msgs = 3)
#> Error: `yield_an_error()` info: There are 3 things to note
#> * message info 1
#> * message info 2
#> * message info 3

yield_an_error(msgs = 2)
#> Error: `yield_an_error()` info: There are 2 things to note
#> * message info 1
#> * message info 2

yield_an_error(msgs = 1)
#> Error: `yield_an_error()` info: There is 1 thing to note
#> * message info 1
}
}
