% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_replace.R
\name{country_replace}
\alias{country_replace}
\title{country_replace}
\usage{
country_replace(messy_countries, threshold = NA, p = 0)
}
\arguments{
\item{messy_countries}{Vector containing the messy country names that will be replaced
by the closest match from \code{country.names}}

\item{threshold}{The maximum distance that will form a match. If this argument
is specified, any element in the messy vector that has no match closer than
the threshold distance will be replaced with NA. Default: NA}

\item{p}{Only used with method "jw", the Jaro-Winkler penatly size. Default: 0}
}
\value{
\code{country_replace()} returns a cleaned version of the bad vector, with each
element replaced by the most similar element of the good vector.
}
\description{
A wrapper function for \code{cat_replace()} that only requires an inputted
vector of messy countries. \code{country_replace()} uses a built in clean list of
country names \code{country.names} as the reference clean vector.
}
\details{
Country names are often misspelled or abbreviated in datasets, especially datasets that have been
manually digitized or created. \code{country_replace()} is a warpper function of \code{cat_replace()} that quickly solves
this common issue of mispellings or different formats of country names across datasets. This wrapper
function uses a built in clean list of country names \code{country.names} as the reference clean vector and
replaces your inputted messy vector of names to their nearest match in \code{country.names}.
}
\examples{
if(interactive()){
 #EXAMPLE1
 lst <- c("Conagoa", "Blearaus", "Venzesual", "Uruagsya", "England")
 fixed <- country_replace(lst)
 }
}
