% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_mdate.R
\name{class_make}
\alias{class_make}
\alias{make_messydate}
\title{Composes \code{mdate} from multiple variables}
\usage{
make_messydate(..., resequence = FALSE)
}
\arguments{
\item{...}{One (yyyy-mm-dd), two (yyyy-mm-dd, yyyy-mm-dd),
or three (yyyy, mm, dd) variables.}

\item{resequence}{Users have the option to choose the order for
ambiguous dates with or without separators (e.g. "11-01-12" or "20112112").
\code{NULL} by default.
Other options include: 'dmy', 'ymd', 'mdy', 'ym', 'my' and 'interactive'
If 'dmy', dates are converted from DDMMYY format for 6 digit dates,
or DDMMYYYY format for 8 digit dates.
If 'ymd', dates are converted from YYMMDD format for 6 digit dates,
or YYYYMMDD format for 8 digit dates.
If 'mdy', dates are converted from MMDDYY format for 6 digit dates
or MMDDYYYY format for 8 digit dates.
For these three options, ambiguous dates are converted to YY-MM-DD format
for 6 digit dates, or YYYY-MM-DD format for 8 digit dates.
If 'my', ambiguous 6 digit dates are converted from MM-YYYY format
to YYYY-MM.
If 'ym', ambiguous 6 digit dates are converted to YYYY-MM format.
If 'interactive', it prompts users to select the existing
component order of ambiguous dates,
based on which the date is reordered into YYYY-MM-DD format
and further completed to YYYY-MM-DD format if they choose to do so.}
}
\description{
Composes \code{mdate} from multiple variables
}
\details{
If three date variables are passed to \code{make_messydate()},
function will create a single date (yyyy-mm-dd) from it.
If two date variables are passed to \code{make_messydate()},
function will create a range of dates from it (yyyy-mm-dd..yyyy-mm-dd).
If one date variable is passed to \code{make_messydate()},
function defaults to \code{as_messydate()}.
}
\examples{
make_messydate("2010", "10", "10")
}
