% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLUE.R
\name{Wan.std}
\alias{Wan.std}
\title{Wan et al.'s standard deviation estimators}
\usage{
Wan.std(X, n, type)
}
\arguments{
\item{X}{a vector of ordered summary statistics}

\item{n}{the sample size}

\item{type}{a character string indicating which type of summary statistics is reported. The options for the \strong{type} argument are: 
\itemize{
   \item "S1" for the sample mean, minimum and maximum values
   \item "S2" for the sample mean, first and third quartiles
   \item "S3" for the sample mean, first and third quartiles, and minimum and maximum values
}}
}
\description{
Use Wan et al.'s methods (Wan et al., 2014) to estimate the sample standard deviation based on sample quantiles derived summaries for a single study.
}
\examples{
X<-c(1,4,10)
n<-30
type<-"S1"
Wan.std(X,n,type)
}
\references{
Wan X,Wang W, Liu J, and Tong T. (2014). Estimating the sample mean and standard deviation from the sample size, median, range and/or interquartile range. \emph{BMC Medical Research Methodology}, \strong{14}:135.
}
