% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_2x2.R
\name{es_from_2x2_sum}
\alias{es_from_2x2_sum}
\title{Convert a table with the number of cases and row marginal sums into several effect size measures}
\usage{
es_from_2x2_sum(
  n_cases_exp,
  n_exp,
  n_cases_nexp,
  n_nexp,
  table_2x2_to_cor = "tetrachoric",
  reverse_2x2
)
}
\arguments{
\item{n_cases_exp}{number of cases/events in the exposed group}

\item{n_exp}{total number of participants in the exposed group}

\item{n_cases_nexp}{number of cases/events in the non exposed group}

\item{n_nexp}{total number of participants in the non exposed group}

\item{table_2x2_to_cor}{formula used to obtain a correlation coefficient from the contigency table (see details).}

\item{reverse_2x2}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab OR + RR + NNT\cr
\tab \cr
\code{converted effect size measure} \tab D + G + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 7. Contingency (2x2) table or proportions'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert a table with the number of cases and row marginal sums into several effect size measures
}
\details{
This function uses the number of cases in both the exposed
and non-exposed groups and the total number of participants exposed and non-exposed
to recreate a 2x2 table.
Then relies on the calculations of the \code{\link{es_from_2x2}} function.
\deqn{n\_controls\_exp = n\_exp - n\_cases\_exp}
\deqn{n\_controls\_nexp = n\_nexp - n\_cases\_nexp}
}
\examples{
es_from_2x2_sum(n_cases_exp = 10, n_exp = 40, n_cases_nexp = 25, n_nexp = 47)
}
