% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_ANCOVA_means.R
\name{es_from_ancova_means_ci}
\alias{es_from_ancova_means_ci}
\title{Convert means and 95\% CIs of two independent groups obtained from an ANCOVA model into several effect size measures}
\usage{
es_from_ancova_means_ci(
  n_exp,
  n_nexp,
  ancova_mean_exp,
  ancova_mean_ci_lo_exp,
  ancova_mean_ci_up_exp,
  ancova_mean_nexp,
  ancova_mean_ci_lo_nexp,
  ancova_mean_ci_up_nexp,
  cov_outcome_r,
  n_cov_ancova,
  max_asymmetry = 10,
  smd_to_cor = "viechtbauer",
  reverse_ancova_means
)
}
\arguments{
\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{ancova_mean_exp}{adjusted mean of participants in the experimental/exposed group.}

\item{ancova_mean_ci_lo_exp}{lower bound of the adjusted 95\% CI of the mean of the experimental/exposed group}

\item{ancova_mean_ci_up_exp}{upper bound of the adjusted 95\% CI of the mean of the experimental/exposed group}

\item{ancova_mean_nexp}{adjusted mean of participants in the non-experimental/non-exposed group.}

\item{ancova_mean_ci_lo_nexp}{lower bound of the adjusted 95\% CI of the mean of the non-experimental/non-exposed group.}

\item{ancova_mean_ci_up_nexp}{upper bound of the adjusted 95\% CI of the mean of the non-experimental/non-exposed group.}

\item{cov_outcome_r}{correlation between the outcome and covariate(s) (multiple correlation when multiple covariates are included in the ANCOVA model).}

\item{n_cov_ancova}{number of covariates in the ANCOVA model.}

\item{max_asymmetry}{A percentage indicating the tolerance before detecting asymmetry in the 95\% CI bounds.}

\item{smd_to_cor}{formula used to convert the adjusted \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_ancova_means}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 19. Adjusted: Means and dispersion'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert means and 95\% CIs of two independent groups obtained from an ANCOVA model into several effect size measures
}
\details{
This function converts the adjusted means 95\% CI of two independent groups
into a standard error,
and then relies on the calculations of the \code{\link{es_from_ancova_means_se}()} function.

\strong{To convert the 95\% CIs into standard errors,} the following formula is used (table 12.3 in Cooper):
\deqn{ancova\_mean\_se\_exp = \frac{ancova\_mean\_ci\_up\_exp - ancova\_mean\_ci\_lo\_exp}{2 * qt(0.975, df = n\_exp - 1)}}
\deqn{ancova\_mean\_se\_nexp = \frac{ancova\_mean\_ci\_up\_nexp - ancova\_mean\_ci\_lo\_nexp}{2 * qt(0.975, df = n\_nexp - 1)}}
Calculations of the \code{\link{es_from_ancova_means_se}()} are then applied.
}
\examples{
es_from_ancova_means_ci(
  n_exp = 55, n_nexp = 55, cov_outcome_r = 0.5, n_cov_ancova = 4,
  ancova_mean_exp = 25, ancova_mean_ci_lo_exp = 15, ancova_mean_ci_up_exp = 35,
  ancova_mean_nexp = 18, ancova_mean_ci_lo_nexp = 12, ancova_mean_ci_up_nexp = 24
)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
