% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARD.R
\name{ARD_from_RR}
\alias{ARD_from_RR}
\title{Absolute Risk Difference}
\usage{
ARD_from_RR(BR, BRLL, BRUL, RR, RRLL, RRUL, seed = 1)
}
\arguments{
\item{BR}{baseline risk}

\item{BRLL}{baseline risk lower limit confidence interval}

\item{BRUL}{baseline risk upper limit confidence interval}

\item{RR}{risk ratio}

\item{RRLL}{risk ratio lower limit confidence interval}

\item{RRUL}{risk ratio upper limit confidence interval}

\item{seed}{seed that is used for the simulation to ensure reproducibility}
}
\value{
Named numeric vector containing median ARD, the lower and upper CI of the ARD.
}
\description{
Calculates the Absolute Risk Difference (ARD) from a Risk Ratio and baseline risk using simulations. The result is ARD as a decimal. The number of replications is fixed at 100,000.
}
\examples{
# Input : Baseline risk and 95\% CI (BR BRLL and BRUL), risk ratio and 95\% CI (RR, RRLL, RRUL)
BR <- 0.053; BRLL <- 0.039; BRUL <- 0.072
RR <- 0.77; RRLL <- 0.63; RRUL <- 0.94
ARD_from_RR(BR, BRLL, BRUL, RR, RRLL, RRUL)
}
\references{
Murad M H, Wang Z, Zhu Y, Saadi S, Chu H, Lin L et al. Methods for deriving risk difference (absolute risk reduction) from a meta-analysis BMJ 2023; 381 :e073141 doi:10.1136/bmj-2022-073141
}
