% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMD.R
\name{SMD_from_mean_matched}
\alias{SMD_from_mean_matched}
\title{Calculates SMD from Matched Groups}
\usage{
SMD_from_mean_matched(M_diff = NA, M1 = NA, M2 = NA, SD_within)
}
\arguments{
\item{M_diff}{mean difference between groups}

\item{M1}{mean group 1 (in case M_diff not provided)}

\item{M2}{mean group 2 (in case M_diff not provided)}

\item{SD_within}{within standard deviation. CAVE this is usually not reported but needs to be computed from the difference standard deviation.
This can be done with \code{\link[=SD_within_from_SD_r]{SD_within_from_SD_r()}}.}
}
\value{
Standardized Mean Differences
}
\description{
Calculates the standardized mean differences for matched groups. Needs either the mean of the groups or the difference between groups.
SD_within is usually not reported but can be calculated by the use of \code{\link[=SD_within_from_SD_r]{SD_within_from_SD_r()}}.
}
\examples{
# Calcuation with group means
SMD_from_mean_matched(M1 = 103, M2 = 100, SD_within = 7.1005)

# Calculation with group difference
SMD_from_mean_matched(M_diff = 3, SD_within = 7.1005)

# Calculation with standard deviation between
# Correlation Coefficient between groups
r <- 0.7

# SD between groups
SD_between <- 5.5

SMD_from_mean_matched(M_diff = 3,
    SD_within = SD_within_from_SD_r(SD_between, r))
}
\references{
M., Hedges, L.V., Higgins, J.P.T. and Rothstein, H.R. (2009). Converting Among Effect Sizes. In Introduction to Meta-Analysis (eds M. Borenstein, L.V. Hedges, J.P.T. Higgins and H.R. Rothstein). https://doi.org/10.1002/9780470743386.ch7
}
