% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preselect.R
\name{preselect_vars}
\alias{preselect_vars}
\title{Extract variable names from mf_preselect object}
\usage{
preselect_vars(x, cutoff = NULL, criterion = NULL)
}
\arguments{
\item{x}{Object of class mf_preselect.}

\item{cutoff}{Numeric. Must be a value between 0 and 1. By default, uses .95
for bootstrapped preselection, and .1 for recursive preselection.}

\item{criterion}{Character. Which criterion to use. See \code{Details} for
more information. By default, uses 'ci' (confidence interval) for
bootstrapped preselection, and 'p' (proportion) for recursive preselection.}
}
\value{
Character vector.
}
\description{
Returns a vector of variable names from an mf_preselect object,
based on a cutoff criterion provided.
}
\details{
For \code{criterion = 'p'}, the function evaluates the proportion of
replications in which a variable achieved a positive (>0) variable
importance. For \code{criterion = 'ci'}, the function evaluates whether the
lower bound of a confidence interval of a variable's importance across
replications exceeds zero. The width of the confidence interval is determined
by \code{cutoff}.

For recursive preselection, any variable not included in a final
model is assigned zero importance.
}
\examples{
\dontrun{
data("dat.bourassa1996", package = "metadat")
df <- dat.bourassa1996
df <- escalc(measure = "OR", ai = lh.le, bi = lh.re, ci = rh.le, di= rh.re,
               data = df, add = 1/2, to = "all")
df$mage[is.na(df$mage)] <- median(df$mage, na.rm = TRUE)
df[c(5:8)] <- lapply(df[c(5:8)], factor)
df$yi <- as.numeric(df$yi)
preselected <- preselect(formula = yi~ selection + investigator + hand_assess + eye_assess +
                        mage +sex,
          df, study = "sample",
          whichweights = "unif", num.trees = 300,
          replications = 10,
          algorithm = "bootstrap")
preselect_vars(preselected)
}
}
