% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inc.R
\name{inc}
\alias{inc}
\alias{print.inc}
\alias{summary.inc}
\alias{print.summary.inc}
\title{Decision Inconsistency and Across-Studies Inconsistency index}
\usage{
inc(
  x,
  dt1,
  dt2 = NULL,
  dt3 = NULL,
  sm,
  br = NULL,
  utility = NULL,
  scale = 1000,
  transf = TRUE,
  transf.dt = FALSE
)

\method{print}{inc}(x, digits = 1, ...)

\method{summary}{inc}(object, ...)

\method{print}{summary.inc}(x, digits = 1, ...)
}
\arguments{
\item{x}{An R object created with \code{\link{getsamples}} or a matrix
containing the sampled effect sizes of primary studies.}

\item{dt1}{A single numeric defining the decision threshold to
distinguish (i) meaningful from trivial effects, if arguments
\code{dt2} and \code{dt3} are not provided, (ii) negative / harmful
from trivial effects, if only argument \code{dt2} is also
provided, or (iii) small from trivial effects if arguments
\code{dt2} and \code{dt3} are provided.}

\item{dt2}{A single numeric defining the decision threshold to
distinguish (i) positive / beneficial from trivial effects if
argument \code{dt3} is not provided, or (ii) moderate from small
effects if argument \code{dt3} is provided.}

\item{dt3}{A single numeric defining the decision threshold to
distinguish large from moderate effects.}

\item{sm}{A character string indicating the summary measure used in
primary studies (see Details).}

\item{br}{Baseline risk (only considered for odds, risk or hazard
ratio).}

\item{utility}{Utility value.}

\item{scale}{The number of people per which absolute decision
thresholds are provided (default: 1000, i.e., absolute decision
threshold values are defined per 1000 persons). Only considered if
\code{br} is not missing.}

\item{transf}{A logical indicating whether the values of an effect
size matrix (argument \code{x}) are to be transformed. By default
\code{transf = TRUE}, it is assumed that the matrix
contains, e.g., log odds ratios instead of odds ratios.}

\item{transf.dt}{A logical indicating whether relative decision
thresholds are transformed or on the original scale. If
\code{transf.dt = FALSE} (default), relative decision thresholds
are expected to be on the natural scale (e.g., odds ratios
instead of log odds ratios for \code{sm = "OR"}). Note, the GRADE working
group recommends to use absolute instead of
relative decision thresholds.}

\item{digits}{Minimal number of significant digits to print
percentages, see \code{print.default}.}

\item{\dots}{Additional arguments (ignored)}

\item{object}{R object of class \code{inc}.}
}
\value{
An object of class \code{inc}, for which some standard methods are
available, see \code{\link{metainc-package}}. Some of the
components include:
\item{DI}{A percentage corresponding to the Decision Inconsistency
  index. The higher / closer to 100\% the value, the higher the
  inconsistency.}
\item{ASI}{A percentage corresponding to the Across-Studies
  Inconsistency index. The higher / closer to 100\% the value, the
  higher the across-studies inconsistency.}
\item{class_distribution}{A data frame containing the proportion of
  samples indicating (if three decision thresholds had been
  provided):
  \itemize{
    \item Large positive effects (effect sizes higher than
      \code{dt3}): "large (higher)" row;
    \item Moderate positive effects (efect sizes between \code{dt2}
      and \code{dt3}): "moderate (higher)" row;
    \item Small positive effects (effect sizes between \code{dt1}
      and \code{dt2}): "small (higher)" row;
    \item Non meaningful effects (effect sizes between \code{-dt1}
      and \code{dt1}): "not meaningful" row;
    \item Small negative effects (effect sizes between \code{-dt1}
      and \code{-dt2}): "small (lower)" row;
    \item Moderate negative effects (effect sizes between
      \code{-dt2} and \code{-dt3}): "moderate (lower)" row;
    \item Large negative effects (effect sizes lower than
      \code{-dt3}): "large (lower)" row.
    }
}
\item{prop_over_null}{A numeric value indicating the proportion of
  samples with a value higher than the value representing no
  difference between the groups.}
}
\description{
Calculates the Decision Inconsistency (DI) and Across-Studies Inconsistency 
(ASI) indices.
}
\details{
Calculates the Decision Inconsistency index (DI) and
the Across-Studies Inconsistency index (ASI) for a meta-analysis. The
following possibilities are considered depending on the type of
effect size measures:
\itemize{
\item Effect size measure corresponding to a ratio (\code{sm =
  "OR"}, \code{"RR"} or \code{"HR"}) with the DI and the ASI being
  calculated based on absolute effects: This requires the specification
  of a baseline risk (i.e., \code{br} must be defined). The
  decision threshold values (\code{dt1}, \code{dt2} and \code{dt3}
  must be provided as absolute effects (i.e., number of additional
  or diminished events per N people. By default, it is assumed that
  these threshold values are provided per 1000 people. However,
  this can be changed using the \code{scale} argument).
\item Effect size measure corresponding to a ratio (\code{sm} =
  \code{"OR"}, \code{"RR"}, \code{"HR"} or \code{"GEN_ratio"}) with
  the DI and the ASI being calculated based on relative effect size
  measures: The sampled effect sizes of primary studies are
  directly compared with decision thresholds (\code{dt1},
  \code{dt2}, \code{dt3}) also expressed as relative effect sizes.
  This is the adopted approach when no information is
  provided on the baseline risk (\code{br}).
\item Effect size measure corresponding to a difference (\code{sm}
  = \code{"MD"}, \code{"SMD"}, \code{"RD"} or \code{"GEN_diff"}):
  The sampled effect sizes of primary studies are directly compared with
  decision thresholds (\code{dt1}, \code{dt2}, \code{dt3}) also expressed
  as differences.
}
  
Of note, when dealing with relative effect size measures,
judgements based on absolute effects tend to be considered more
important for decision making. The formulae for calculating
absolute effects based on relative effect size measures are those
used by the GRADE approach (see references below).

Ideally, arguments \code{dt1}, \code{dt2} and \code{dt3} should be
provided. If only one decision threshold is available, it is either
possible to provide (i) only \code{dt1}, or (ii) both \code{dt1}
and \code{dt2} (if the threshold distinguishing clinically relevant
benefits vs trivial effects is different from that distinguishing
clinically relevant harms vs trivial effects).

Argument \code{sm} must be \code{"OR"} (odds ratio), \code{"RR"}
(risk ratio), \code{"HR"} (hazard ratio), \code{"MD"} (mean
difference), \code{"SMD"} (standardised mean difference),
\code{"RD"} (risk difference), \code{"GEN_diff"} (generic
difference), or \code{"GEN_ratio"} (generic ratio).

The baseline risk (\code{br}) must be a numeric value between 0 and
1. It can be provided when \code{sm = "OR"}, \code{"RR"} or
'\code{"HR"}. The baseline risk is also known as assumed comparator
risk (i.e., the risk that the outcome of interest occurs in the
comparison intervention).
}
\examples{

# Example with effect sizes measures expressed as ratios and with
# calculation of the Decision Inconsistency index and the Across-Studies
# Inconsistency index based on absolute effects:

data(anticoagulation)
inc_anticoagulation <-
  inc(anticoagulation, dt1 = 16, dt2 = 31, dt3 = 60, br = 0.5, sm = "OR",
      transf = FALSE)
inc_anticoagulation

# Same result
inc_anticoagulation <-
  inc(log(anticoagulation), dt1 = 16, dt2 = 31, dt3 = 60,
    br = 0.5, sm = "OR")
inc_anticoagulation

# Example with calculation of the Decision Inconsistency index and the 
# Across-Studies Inconsistency index based on effect size measures expressed
# as mean differences:

data(montelukast)
inc_montelukast <- inc(montelukast, dt1 = 0.2, dt2 = 0.4, dt3 = 0.6, sm = "md")
inc_montelukast

}
\references{
Cohen J. (1998).
\dQuote{Statistical Power Analysis in the Behavioral Sciences},
2nd edition ed. Hillsdale (NJ): Lawrence Erlbaum Associates, Inc.

Schunemann HJ, Higgins JPT, Vist GE, et al. (2019).
\dQuote{Completing ‘Summary of findings’ tables and grading the certainty of
the evidence.}
\emph{Cochrane Handbook for Systematic Reviews of Interventions},
375--402.

Schunemann HJ, Vist GE, Higgins JPT, et al. (2019).
\dQuote{Interpreting results and drawing conclusions.}
\emph{Cochrane Handbook for Systematic Reviews of Interventions},
403--431.

Skoetz N, Goldkuhle M, van Dalen EC, et al. (2020).
\dQuote{GRADE guidelines 27: how to calculate absolute effects for
time-to-event outcomes in summary of findings tables and Evidence Profiles.}
\emph{Journal of Clinical Epidemiology}, \bold{118},
124--131.

#' Sousa-Pinto B, Neumann I, Vieira RJ, et al. (2025).
\dQuote{Quantitative assessment of inconsistency in meta-analysis using
decision thresholds with two new indices.}
\emph{Journal of Clinical Epidemiology}, \bold{181},
111725.
}
\author{
Bernardo Sousa-Pinto \email{bernardo@med.up.pt},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{print}
