% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_d1_data.R
\name{download_d1_data}
\alias{download_d1_data}
\title{Download data and metadata from DataONE}
\usage{
download_d1_data(data_url, path)
}
\arguments{
\item{data_url}{(character) An identifier or URL for a DataONE object to download.}

\item{path}{(character) Path to a directory to download data to.}
}
\value{
(character) Path where data is downloaded to.
}
\description{
Downloads a data object from DataONE along with metadata.
}
\examples{
\dontrun{
download_d1_data("urn:uuid:a2834e3e-f453-4c2b-8343-99477662b570", path = file.path("."))
download_d1_data(
   "https://cn.dataone.org/cn/v2/resolve/urn:uuid:a2834e3e-f453-4c2b-8343-99477662b570",
    path = file.path(".")
    )
}
}
\seealso{
[read_d1_files()] [download_d1_data_pkg()]
}
