% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metatab.show.R
\name{metatab.show}
\alias{metatab.show}
\title{Display meta-analysis results.}
\usage{
metatab.show(
  metatab,
  com.pooled.tab,
  sumvar = "taxa",
  highest.lev = "g",
  tax.lev = "l2",
  showvar,
  estimate.pattern = "Estimate.",
  se.pattern = "Std. Error.",
  p.pattern = "Pr(>|t|)",
  readjust.p = FALSE,
  p.cutoff.type = "p",
  p.cutoff = 0.05,
  display = "plot",
  plot = "heatmap",
  fill.value = "log(OR)",
  grid = FALSE,
  digit = 2,
  p.digit = 4
)
}
\arguments{
\item{metatab}{matrice of taxa/pathway abundance comparison meta-analysis results generated from meta.taxa.}

\item{com.pooled.tab}{matrice of taxa/pathway abundance comparison generated from taxa.compare or pathway.compare combined from all included studies.}

\item{sumvar}{Either "taxa" for taxa and "path" for pathway.}

\item{highest.lev}{Highest level of bacterial taxonomies available for analysis. Options are "g" for genus (usually for 16S data) and "s" for species (usually for shortgun data).}

\item{tax.lev}{taxa level to be displayed. Options are from "l2" (phylum) to "l7" (species). Default is "l2".}

\item{showvar}{variable (string pattern) in the model to be displayed.}

\item{estimate.pattern}{string pattern for estimates. Default is "Estimate.".}

\item{se.pattern}{string pattern for standard error variable. Default is "Std. Error.".}

\item{p.pattern}{string pattern for p-value variable. Default is "Pr(>|t|)".}

\item{readjust.p}{multiple testing re-adjustment for only the level to be displayed (TRUE) or keep original multiple testing adjustment for all taxa of all levels (FALSE).Default is FALSE.}

\item{p.cutoff.type}{type of p-value for cutoff. Options are "p" for p-value or "p.adjust" for multiple testing adjusted p-value. Default is "p".}

\item{p.cutoff}{cutoff p-value to be displayed. Default is 0.05.}

\item{display}{type of display. Options are display=c("plot","table","data")}

\item{plot}{type of plot. Options are plot=c("heatmap","forest").}

\item{fill.value}{name of legend.}

\item{grid}{whether multiple plots will be displayed alongside. Default is FALSE.}

\item{digit}{digit for estimates and 95 CI. Default is 2.}

\item{p.digit}{digit for p-values. Default is 4.}
}
\value{
plot table or data.
}
\description{
This function displays meta-analysis results of relative abundance as heatmap, forest plot, table or data.
}
\examples{
# Load saved GAMLSS-BEZI results of four studies for the comparison of
# bacterial taxa relative abundance between genders adjusted for
# breastfeeding and infant age at sample collection
data(tabsex4)
#select only taxonomies of a small phylum for meta-analysis example
# (to save running time)
tlm<-tabsex4$id[grep("k__bacteria.p__fusobacteria",tabsex4$id)]
# meta-analysis
metab.sex<-meta.taxa(taxcomdat=tabsex4[tabsex4$id \%in\% tlm,],
summary.measure="RR", pool.var="id", studylab="study",
backtransform=FALSE, percent.meta=0.5, p.adjust.method="fdr")
#show results by table and plot
#phylum
#table
metatab.show(metatab=metab.sex$random,com.pooled.tab=tabsex4[tabsex4$id \%in\% tlm,],
tax.lev="l2",showvar="genderMale",p.cutoff.type="p", p.cutoff=1,display="table")
#plot
metadat<-metatab.show(metatab=metab.sex$random,com.pooled.tab=tabsex4[tabsex4$id \%in\% tlm,],
tax.lev="l2",showvar="genderMale",p.cutoff.type="p", p.cutoff=1,display="data")
meta.niceplot(metadat=metadat,sumtype="taxa",level="main",p="p",
p.adjust="p.adjust",phyla.col="rainbow",p.sig.heat="yes",
heat.forest.width.ratio =c(1.5,1), leg.key.size=0.8,
leg.text.size=10, heat.text.x.size=10, heat.text.x.angle=0,
forest.axis.text.y=8,forest.axis.text.x=10,
point.ratio = c(4,2),line.ratio = c(2,1))
}
\keyword{abundance}
\keyword{display.}
\keyword{meta-analysis}
