% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.filter.R
\name{taxa.filter}
\alias{taxa.filter}
\title{Filter relative abundance data}
\usage{
taxa.filter(taxtab, percent.filter = 0.05, relabund.filter = 5e-05)
}
\arguments{
\item{taxtab}{taxa/pathway relative abundance table.}

\item{percent.filter}{prevalence threshold (the percentage of number of samples the taxa/pathway available). Default is 0.05.}

\item{relabund.filter}{relative abundance threshold (the minimum of the average relative abundance for a taxa/pathway to be retained). Default is 0.00005.}
}
\value{
list of all taxa/pathways retained after filtering.
}
\description{
This function filters bacterial taxa or pathway relative abundance tables based on the percentage of samples with their availability (prevalence) and relative abundance thresholds.
It will remove taxa/pathway with relative abundance <relabund.filter and available in <percent.filter of number of samples.
}
\examples{
#Load summary tables of bacterial taxa relative abundance from Bangladesh data
data(taxtab6)
taxlist.rm<-taxa.filter(taxtab=taxtab6,percent.filter = 0.05,
relabund.filter = 0.00005)
}
\keyword{abundance}
\keyword{filter}
\keyword{relative}
