% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_plot.R
\name{ge_plot}
\alias{ge_plot}
\title{Graphical analysis of genotype-vs-environment interaction}
\usage{
ge_plot(
  .data,
  env,
  gen,
  resp,
  type = 1,
  values = TRUE,
  text_col_pos = c("top", "bottom"),
  text_row_pos = c("left", "right"),
  average = TRUE,
  row_col = TRUE,
  row_col_type = c("average", "sum"),
  order_g = NULL,
  order_e = NULL,
  xlab = NULL,
  ylab = NULL,
  width_bar = 1.5,
  heigth_bar = 15,
  plot_theme = theme_metan(),
  colour = TRUE
)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{resp}{The response variable.}

\item{type}{The type of plot \code{type = 1} for a heatmap or \code{type = 2}
for a line plot.}

\item{values}{Show the values in the plot? Defaults to \code{TRUE}.}

\item{text_row_pos, text_col_pos}{The position of the text in the
rows and columns. The defaults show the text at left and top.}

\item{average}{Show the average values for environments and genotypes?
Defaults to \code{TRUE}.}

\item{row_col, row_col_type}{Shows row/column and defines what to show.
Defaults to 'average'.}

\item{order_g, order_e}{A charactere vector indicating the order of the levels
for genotypes and environments, respectively. This can be used to change
the default ordering of rows and columns.}

\item{xlab, ylab}{The labels for x and y axis, respectively.}

\item{width_bar, heigth_bar}{The width and heigth of the legend bar,
respectively.}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details,see
\code{\link[ggplot2:theme]{ggplot2::theme()}}.}

\item{colour}{Logical argument. If \code{FALSE} then the plot will not be
colored.}
}
\value{
An object of class \verb{gg, ggplot}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function produces a line plot for a graphical interpretation of the
genotype-vs-environment interaction. By default, environments are in the x
axis whereas the genotypes are depicted by different lines. The y axis
contains the value of the selected variable. A heatmap can also be created.
}
\examples{
\donttest{
library(metan)
ge_plot(data_ge2, ENV, GEN, PH)
ge_plot(data_ge, ENV, GEN, GY, type = 2)
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
