% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{region}
\alias{region}
\title{Calculate a Confidence Region}
\usage{
region(
  x,
  y,
  family = if (all(y \%in\% 0:1, na.rm = TRUE)) "binomial" else "gaussian",
  length.out = 1000,
  conf = 0.95,
  ...
)
}
\arguments{
\item{x}{x values}

\item{y}{y values}

\item{family}{gaussian by default, or binomial for all y either zero or 1}

\item{length.out}{number of prediction points}

\item{conf}{width of confidence interval; logical TRUE defaults to 0.95}

\item{...}{passed to \code{\link{model}}}
}
\value{
data.frame with x, y, hi, lo at 1000 points
}
\description{
Calculates a confidence region. \code{se.fit} from \code{\link[stats]{predict.glm}} is multiplied by \code{z} and added or subtracted from fits to give \code{hi} and \code{lo} columns in return value.  \code{z} is normal quantile for the one-tailed probablitity corresponding to \code{conf}, e.g. ~ 1.96 for \code{conf = 0.95}. If non-missing \code{y} is only 0 or 1, the model family is binomial and resulting confidence intervals are back-transformed using \code{\link[stats]{plogis}}.
}
\seealso{
\url{https://stackoverflow.com/questions/14423325/confidence-intervals-for-predictions-from-logistic-regression}

\url{https://stat.ethz.ch/pipermail/r-help/2010-September/254465.html}

Other regression functions: 
\code{\link{metastats}()},
\code{\link{model}()}
}
\concept{regression functions}
\keyword{internal}
