% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ari_matrix}
\alias{plot.ari_matrix}
\alias{meta_cluster_heatmap}
\title{Heatmap of pairwise adjusted rand indices between solutions}
\usage{
\method{plot}{ari_matrix}(
  x,
  order = NULL,
  cluster_rows = FALSE,
  cluster_columns = FALSE,
  log_graph = FALSE,
  scale_diag = "none",
  min_colour = "#282828",
  max_colour = "firebrick2",
  col = circlize::colorRamp2(c(min(x), max(x)), c(min_colour, max_colour)),
  ...
)

meta_cluster_heatmap(
  x,
  order = NULL,
  cluster_rows = FALSE,
  cluster_columns = FALSE,
  log_graph = FALSE,
  scale_diag = "none",
  min_colour = "#282828",
  max_colour = "firebrick2",
  col = circlize::colorRamp2(c(min(x), max(x)), c(min_colour, max_colour)),
  ...
)
}
\arguments{
\item{x}{Matrix of adjusted rand indices from \code{calc_aris()}}

\item{order}{Numeric vector containing row order of the heatmap.}

\item{cluster_rows}{Whether rows should be clustered.}

\item{cluster_columns}{Whether columns should be clustered.}

\item{log_graph}{If TRUE, log transforms the graph.}

\item{scale_diag}{Method of rescaling matrix diagonals. Can be "none"
(don't change diagonals), "mean" (replace diagonals with average value of
off-diagonals), or "zero" (replace diagonals with 0).}

\item{min_colour}{Colour used for the lowest value in the heatmap.}

\item{max_colour}{Colour used for the highest value in the heatmap.}

\item{col}{Colour ramp to use for the heatmap.}

\item{...}{Additional parameters passed to \code{similarity_matrix_heatmap()},
the function that this function wraps.}
}
\value{
Returns a heatmap (class "Heatmap" from package ComplexHeatmap)
that displays the pairwise adjusted Rand indices (similarities) between
the cluster solutions of the provided solutions data frame.
}
\description{
Heatmap of pairwise adjusted rand indices between solutions
}
\examples{
\donttest{
    dl <- data_list(
        list(cort_sa, "cortical_surface_area", "neuroimaging", "continuous"),
        list(subc_v, "subcortical_volume", "neuroimaging", "continuous"),
        list(income, "household_income", "demographics", "continuous"),
        list(pubertal, "pubertal_status", "demographics", "continuous"),
        uid = "unique_id"
    )
    
    set.seed(42)
    my_sc <- snf_config(
        dl = dl,
        n_solutions = 20,
        min_k = 20,
        max_k = 50
    )
    
    sol_df <- batch_snf(dl, my_sc)
    
    sol_df
    
    sol_aris <- calc_aris(sol_df)
    
    meta_cluster_order <- get_matrix_order(sol_aris)
    
    # `split_vec` found by iteratively plotting ari_hm or by ?shiny_annotator()
    split_vec <- c(6, 10, 16)
    ari_hm <- plot(
        sol_aris,
        order = meta_cluster_order,
        split_vector = split_vec
    )
}
}
