% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deft_show.R
\name{deft_show}
\alias{deft_show}
\title{Show deft result}
\usage{
deft_show(
  deft,
  element,
  study_labels = NULL,
  headings = list(study = ifelse(element == "all", "Study-subgroup", "Study"), n = "N",
    measure = NULL, ci = "HR (95\% CI)"),
  trans = base::exp,
  show_model = ifelse(element == "all", FALSE, TRUE),
  show_stats = list(`I^2` = rlang::quo(sprintf("\%0.1f\%\%", I2)), p =
    rlang::quo(format.pval(QEp, digits = 2))),
  ...
)
}
\arguments{
\item{deft}{result from \link{deft_do}.}

\item{element}{'all' or 'subgroup'.}

\item{study_labels}{labels for studies.}

\item{headings}{a list for controlling plot headings.}

\item{trans}{an optional transform function used on the numeric data for plotting the axes}

\item{show_model}{a logical value, if \code{TRUE}, show model result, otherwise only show forest plots for studies}

\item{show_stats}{a \code{list} of stats to show at the bottom of the forest plot for e.g. heterogeneity}

\item{...}{other arguments except 'panels', 'trans', 'study_labels',
and 'show_stats' passed to \code{\link[forestmodel:forest_rma]{forestmodel::forest_rma()}}.}
}
\value{
a \code{ggplot} object
}
\description{
Show deft result
}
\examples{
data("wang2019")
res <- deft_do(wang2019, group_level = c("Male", "Female"))

p1 <- deft_show(res, "all")
p1

p2 <- deft_show(res, "subgroup")
p2
}
\author{
ShixiangWang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
