% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_operators.R
\name{jacobian}
\alias{jacobian}
\title{Jacobian matrix and determinant}
\usage{
jacobian(
  fld1,
  fld2,
  fld3 = NULL,
  lat = NULL,
  d = 3,
  system = "p",
  rho = NULL,
  dx = 0.25,
  dy = 0.25,
  plev = 5000,
  mode = "lonlat"
)
}
\arguments{
\item{fld1}{field 1 with dimensions (lon,lat,p)}

\item{fld2}{field 2 with dimensions (lon,lat,p)}

\item{fld3}{field 3 with dimensions (lon,lat,p)}

\item{lat}{vector containing latitude}

\item{d}{scalar for dimension (use d=2 for 2 input fields and d=3 for 3 inpt fields)}

\item{system}{for type of coordinate system (use 'p' for pressure system and 'z' for height system)}

\item{rho}{field with dimensions (lon,lat,p) for density or a scalar rho (for constant density)}

\item{dx}{x resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{dy}{y resolution in the corresponding unit (e.g. 0.25 degree for ERA5 with \code{mode='lonlat'} or e.g. 1000 m in cartesian coordinates with \code{mode='cartesian'})}

\item{plev}{a scalar containing the p resolution (if equidistant) or a vector containing pressure levels in Pa (for non-equidistant)}

\item{mode}{the coordinate system, options are lonlat for a longitude-latitude-grid (default), or cartesian for an equidistant cartesian grid}
}
\value{
list containing Jacobian matrix and determinant
}
\description{
Calculates the Jacobian matrix and Jacobian determinant for 2 or 3 given scalar fields
}
