% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_main.R
\name{varevalue.single_general}
\alias{varevalue.single_general}
\title{A general method to calculate the e-value for other DNA methylation tools not described above. The input data is the DNA methylation rates using the similar format with Metilene.}
\usage{
varevalue.single_general(
  methyrate,
  group1_name = "g1",
  group2_name = "g2",
  chr,
  start,
  end
)
}
\arguments{
\item{methyrate}{data.frame: A data.frame object of methylation rates, the columns should be (name of groups can be self-defined)
\tabular{rrrrrrrr}{
 chr    \tab  pos     \tab   g1    \tab ...  \tab  g1 \tab  g2 \tab ... \tab g2 \cr
chr1 \tab  1    \tab  0.1 \tab  ... \tab   0.1\tab  0.2\tab ... \tab 0.2\cr
}}

\item{group1_name}{charactor: The name (pattern) of the first group. For example, "g1" in the above example.
For example `g1_abc` and `g1` will be considered as the same group if `group1_name = "g1"`.  Use this with care in practice.}

\item{group2_name}{charactor: The name (pattern) of the second group. For example, "g2" in the above example.
For example `g2_abc` and `g2` will be considered as the same group if `group2_name = "g2"`.  Use this with care in practice.}

\item{chr}{charactor: The Chromosome name. Typically, it is a string like "chr21" and so on.}

\item{start}{integer:  The position of the start site of the corresponding region}

\item{end}{integer: The position of the end site of the corresponding region}
}
\value{
evalue
}
\description{
The input data file is just the DNA methylation rates using the similar format above, with no need for another data file output by different tools.
The Chromosome name, start and end sites shoule be specified in the function.
}
\examples{
#data("demo_metilene_input")
#varevalue.single_general(demo_metilene_input, chr = "chr21", start = 9437432, end = 9437540)
# [1] 2.626126e+43

#### Compare to `metevalue.metilene`  ####
data(demo_metilene_out)
#example_tempfiles = tempfile(c("metilene_input", "metilene_out"))
#tempdir()
#write.table(demo_metilene_input, file=example_tempfiles[1],
#      row.names=FALSE, col.names=TRUE, quote=FALSE, sep='\t')
#write.table (demo_metilene_out, file=example_tempfiles[2],
#      sep ="\t", row.names =FALSE, col.names =TRUE, quote =FALSE)
#result = metevalue.metilene(example_tempfiles[1], example_tempfiles[2],
#      bheader = TRUE)
# result[with(result, chr == 'chr21' & start == '9437432' & end == '9437540'), ncol(result)]
# [1] 2.626126e+43
}
