% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpts.R
\name{mp.ts}
\alias{mp.ts}
\title{Multi serie plot in time serie format}
\usage{
mp.ts(
  object,
  xaxis,
  yaxis,
  dateformat = "\%Y-\%m",
  datebreaks = "1 month",
  ybreaks = 10,
  percent = FALSE,
  yaccuracy = 0.01,
  ydecimalmark = ".",
  title = "Title",
  xlab = "X axis",
  ylab = "Y axis",
  stitle = NULL,
  note = NULL,
  ctitles = "black",
  cscales = ctitles,
  cbgrid = "white",
  clgrid = cbgrid,
  cplot = "white",
  cticks = "black",
  pnote = 1,
  cbord = cplot,
  titlesize = 20,
  wordssize = 12,
  snote = 11,
  xlim = NULL
)
}
\arguments{
\item{object}{a ggplot graphic object}

\item{xaxis}{x axis of one of your graphics}

\item{yaxis}{y axis of one of your graphics}

\item{dateformat}{format of date in x axis (need a dataformat string) (default ="\%Y-\%m")}

\item{datebreaks}{datebreaks in x axis (default="1 month")}

\item{ybreaks}{number of y axis breaks (default=10)}

\item{percent}{If TRUE y axis in percent (default=F)}

\item{yaccuracy}{a round for y axis (default=0.01)}

\item{ydecimalmark}{y decimal mark (default=".")}

\item{title}{title of plot}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{stitle}{subtitle}

\item{note}{note}

\item{ctitles}{color of titles (title,xlab,ylab)}

\item{cscales}{color of the scales (default= same ctitles)}

\item{cbgrid}{color of grid background}

\item{clgrid}{color of grid lines}

\item{cplot}{color of plot background}

\item{cticks}{color of axis ticks}

\item{pnote}{position of note (default=1) (only numbers)}

\item{cbord}{color of plot border (default= same cplot)}

\item{titlesize}{size of title (default=20) (only numbers)}

\item{wordssize}{size of words (default=12) (only numbers)}

\item{snote}{size of note (default=11) (only numbers)}

\item{xlim}{limit of x axis (default=NULL)}
}
\value{
Return a graphic.
}
\description{
mp.ts make plot in time serie format with one or more series.
The data don't need be a ts object.
The object parameter require a ggplot object (Look at the examples).
}
\examples{
v=data.frame("x"=seq.Date(as.Date('2020-01-01'),
to = as.Date('2020-05-01'),by='month'),"y"=c(5,3,7,10,9),"y2"=c(7,2,5,8,7))

g= ggplot2::ggplot()+ggplot2::geom_line(mapping=ggplot2::aes(x=v$x,y=v$y),lwd=2)+
ggplot2::geom_line(mapping=ggplot2::aes(x=v$x,y=v$y2),color='blue',lwd=2)

mp.ts(object=g,xaxis=v$x,yaxis=v$y,title="Simple example")

mp.ts(g,v$x,v$y,percent=TRUE,title="Example with percent data",xlab=NULL,ylab=NULL)

mp.ts(g,v$x,v$y,percent=TRUE,yaccuracy=1,title="y accuracy set",xlab=NULL,ylab=NULL)

g= ggplot2::ggplot()+ggplot2::geom_area(mapping=ggplot2::aes(x=v$x,y=v$y),
fill='red',lwd=2)+
ggplot2::geom_area(mapping=ggplot2::aes(x=v$x,y=v$y2),fill='blue',lwd=2)

mp.ts(g,v$x,v$y,dateformat="\%B",title="Example with area plot")

v=data.frame("x"=seq.Date(as.Date('2020-01-01'),
to = as.Date('2020-05-01'),by='month'),"y"=c(5,-3,-6,10,7))

g= ggplot2::ggplot()+ggplot2::geom_col(ggplot2::aes(x=v$x,y=v$y),
fill=p.colorbypositive(v$y),color='black',lwd=1)+
ggplot2::geom_line(ggplot2::aes(x=v$x,y=v$y),color='black',lwd=1)

mp.ts(g,v$x,v$y,title="Example with colorbypositive",xlab=NULL,ylab=NULL)

}
