% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rail-stations.R
\name{rail_stations}
\alias{rail_stations}
\title{Rail Station List}
\format{
A tibble 1 row per station with 10 variables:
\describe{
\item{StationCode}{Station code for this station. Use this value in other
rail-related APIs to retrieve data about a station.}
\item{StationName}{Full name for this station, as shown on the WMATA
website.}
\item{StationTogether}{For stations with multiple platforms (e.g.: Gallery
Place, Fort Totten, L'Enfant Plaza, and Metro Center), the additional
\code{StationCode} will be listed here.}
\item{LineCodes}{Character vector of two-letter abbreviations (e.g.: RD,
BL, YL, OR, GR, or SV) served by this station. If the station has an
additional platform, the lines served by the other platform are listed in
the \code{LineCodes} values for the record associated with the \code{StationCode}
found in \code{StationTogether.}}
\item{Lat}{Latitude.}
\item{Lon}{Longitude.}
\item{Street}{Street address (for GPS use).}
\item{City}{City.}
\item{State}{State (abbreviated).}
\item{Zip}{Zip code.}
}
}
\usage{
rail_stations(LineCode = NULL, api_key = wmata_key())
}
\arguments{
\item{LineCode}{Two-letter line code abbreviation, or \code{NULL} (default):
\itemize{
\item RD - Red
\item YL - Yellow
\item GR - Green
\item BL - Blue
\item OR - Orange
\item SV - Silver
}}

\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
A data frame of stations on a rail line.
}
\description{
Returns a list of station location and address information based on a given
\code{LineCode}. Use \code{NULL} (default) to return all stations. The response is an
data frame identical to that returned in the Station Information method.
}
\examples{
\dontrun{
rail_stations("RD")
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/5476364f031f590f38092507/operations/5476364f031f5909e4fe3311}

Other Rail Station Information: 
\code{\link{rail_destination}()},
\code{\link{rail_entrance}()},
\code{\link{rail_lines}()},
\code{\link{rail_path}()},
\code{\link{rail_times}()},
\code{\link{station_info}()}
}
\concept{Rail Station Information}
