% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{phreg}
\alias{phreg}
\alias{phreg.par}
\alias{robust.phreg}
\alias{readPhreg}
\alias{conftype}
\alias{plotO.predictphreg}
\alias{plotpredictphreg}
\alias{predictO.phreg}
\alias{predictrecreg}
\alias{summarybase.phreg}
\alias{namesortme}
\alias{construct_id}
\title{Fast Cox PH regression}
\usage{
phreg(formula, data, offset = NULL, weights = NULL, ...)
}
\arguments{
\item{formula}{formula with 'Surv' outcome (see \code{coxph})}

\item{data}{data frame}

\item{offset}{offsets for Cox model}

\item{weights}{weights for Cox score equations}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Fast Cox PH regression
Robust variance is default variance with the summary.
}
\details{
influence functions (iid) will follow numerical order of given cluster variable
so ordering after $id will give iid in order of data-set.
}
\examples{
library(mets)
data(TRACE)
dcut(TRACE) <- ~.
out1 <- phreg(Surv(time,status==9)~vf+chf+strata(wmicat.4)+cluster(id),data=TRACE)
summary(out1)

par(mfrow=c(1,2))
plot(out1)

## computing robust variance for baseline
rob1 <- robust.phreg(out1)
plot(rob1,se=TRUE,robust=TRUE)

## iid decomposition, with scaled influence functions
## for regression parameters
head(iid(out1))
## making iid decomposition of baseline at a specific time-point
Aiiid <- iid(out1,time=30)
head(Aiiid)
## both iid decompositions
dd <- iidBaseline(out1,time=30)
head(dd$beta.iid)
head(dd$base.iid)

}
\author{
Klaus K. Holst, Thomas Scheike
}
