% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailindex.R
\name{fit.rho}
\alias{fit.rho}
\title{Estimator of the second order tail index parameter}
\usage{
fit.rho(xdat, k, method = c("fagh", "dk", "ghp", "gbw"), ...)
}
\arguments{
\item{xdat}{vector of positive observations}

\item{k}{number of highest order statistics to use for estimation}

\item{method}{string for the estimator}

\item{...}{additional arguments passed to individual routinescurrently ignored.}
}
\description{
Estimator of the second order tail index parameter
}
\examples{
# Example with rho = -0.2
n <- 1000
xdat <- mev::rgp(n = n, shape = 0.2)
kmin <- floor(n^0.995)
kmax <- ceiling(n^0.999)
rho_est <- fit.rho(
   xdat = xdat,
   k = n - kmin:kmax)
rho_med <- mean(rho_est$rho)
}
