% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalks.R
\name{symbol_to_identifier}
\alias{symbol_to_identifier}
\title{Convert marker symbols to updated marker identifiers}
\usage{
symbol_to_identifier(x, report_file = NULL, n_max = Inf)
}
\arguments{
\item{x}{A character vector of marker symbols to be remapped.}

\item{report_file}{The path to a MRK_List1.rpt file. Leave this as \code{NULL}
and the function will automatically download the report from
\url{https://www.informatics.jax.org/downloads/reports/MRK_List1.rpt}.}

\item{n_max}{Maximum number of lines to read from the \code{report_file}.}
}
\description{
\code{\link[=symbol_to_identifier]{symbol_to_identifier()}} remaps old marker symbols to, in-use, most up
to date marker identifiers.
}
\examples{
rpt_ex01 <- report_example("MRK_List1-EX01.rpt")
read_report(report_file = rpt_ex01, report_type = "MRK_List1") |>
  dplyr::select("marker_status", "marker_symbol", "marker_id_now")

# NB:
#   - "1700024N20Rik" has two conflicting mappings, so maps to `NA`.
#   - "Hes1" is not present in MRK_List1-EX01.rpt, so maps to `NA`.
#   - "Plpbp" (official) and "Prosc" (withdrawn) both map to "MGI:1891207"

marker_symbols <- c("2200002F22Rik", "Plpbp", "Prosc", "1700024N20Rik", "Hes1")
symbol_to_identifier(x = marker_symbols, report_file = rpt_ex01)

}
