% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocs.R
\docType{data}
\name{clayton_sim}
\alias{clayton_sim}
\title{Simulated Clayton-Oakes data.}
\format{
A data frame with 150 rows and 5 variables:
\describe{
\item{Theta:}{Parameter value in Clayton-Oakes model.}
\item{S1:}{min(T_1, C_1), where T_1 is time of interest and C_1 is a
censoring variable. We see T_1 if it is not censored (i.e. C_1 > T_1),
and we see C_1 otherwise.}
\item{d1:}{I(T_1=S_1), i.e. 1 if T_1 = S_1 and 0 otherwise.}
\item{S2:}{See S1.}
\item{d2:}{See d1.}
}
}
\source{
Table 3.4, page 70 of Prentice and Zhao 2019.
}
\usage{
data(clayton_sim)
}
\description{
Data simulated under Clayton-Oakes model (Equation 1.7, page 7 of Prentice
and Zhao) at various theta values and n = 50, with each observed time having
a 1/3 probability of being censored. Variate T_i is right-censored by C_i
for i = 1,2 (see pages 52 and 53 of Prentice and Zhao 2019), and
min(T_i,C_i) = S_i, with delta_i = 1 if T_i = S_i, and 0 otherwise
(i.e., if T_i = S_i then the data was not censored).
}
\references{
Prentice, R., Zhao, S. "The statistical analysis of multivariate
failure time data: A marginal modeling approach", CRC Press (2019).
}
\keyword{datasets}
