% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within_variance_comp_emmeans.R
\name{within_variance_comp_emmeans}
\alias{within_variance_comp_emmeans}
\title{Multiple Imputation Within Variance Component}
\usage{
within_variance_comp_emmeans(ind, peptide, data, metacond)
}
\arguments{
\item{ind}{index}

\item{peptide}{name of the peptide}

\item{data}{dataset}

\item{metacond}{a factor to specify the groups}
}
\value{
A variance-covariance matrix.
}
\description{
Computes the multiple imputation within variance component using the emmeans package.
}
\examples{
library(mi4p)
data(datasim)
datasim_imp <- multi.impute(data = datasim[,-1], conditions = 
attr(datasim,"metadata")$Condition, method = "MLE")
within_variance_comp_emmeans(1,1,datasim_imp,
attr(datasim,"metadata")$Condition)
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}.  \doi{doi:10.1371/journal.pcbi.1010420}.
}
\author{
Frédéric Bertrand
}
