% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.taxonomies.R
\name{mica.taxonomies}
\alias{mica.taxonomies}
\title{Get the taxonomies}
\usage{
mica.taxonomies(
  mica,
  query = NULL,
  locale = "en",
  target = "variable",
  taxonomies = NULL,
  df = TRUE
)
}
\arguments{
\item{mica}{A Mica object}

\item{query}{The search query}

\item{locale}{The language for labels (when NULL labels are not included in the result)}

\item{target}{What the taxonomy is about: variable (default), dataset, study, network}

\item{taxonomies}{Taxonomy names to subset. If NULL or empty all taxonomies are returned}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get the taxonomies, optionally filtered by taxonomy name and by term matching.
}
\examples{
\dontrun{
m <- mica.login("https://mica-demo.obiba.org")
mica.taxonomies(m, target="variable", query="sex", locale="en",
  taxonomies = list("Mlstr_area", "Mlstr_additional"))
mica.logout(m)
}
}
\seealso{
Other taxonomies functions: 
\code{\link{mica.vocabularies}()}
}
\concept{taxonomies functions}
