% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_group_list.R
\name{generate_group_list}
\alias{generate_group_list}
\alias{ask_group_list}
\title{Generate list of group IDs from user parameters}
\usage{
generate_group_list(group_names, file_list)

ask_group_list(file_list)
}
\arguments{
\item{group_names}{A character vector containing IDs for each group.}

\item{file_list}{A character vector of file IDs. Used to extract group IDs from.}
}
\value{
\code{generate_group_list} returns a list of group IDs where each level is assigned to a corresponding 
        row or column based on the selected direction parameter.

\code{ask_group_list} returns a list containing group identifiers as keys and group IDs as values.
}
\description{
\code{generate_group_list} generates a list of provided group IDs extracted
from file IDs.

\code{ask_group_list} works the same way as \code{generate_group_list}, but retrieves the
group IDs based on a user prompt instead of user-set parameters.
}
\details{
\code{generate_group_list} extracts unique identifiers from file IDs and matches them with the 
provided group IDs. If the number of group IDs does not match the number 
of unique identifiers extracted from the file IDs, it throws an error. If the lengths match,
it generates a list of group IDs where each ID is associated with a unique
identifier extracted from the file IDs.
}
\seealso{
\code{\link{generate_experiment_list}}, \code{\link{ask_experiment_list}},
\code{\link{add_treatment}}, \code{\link{add_concentration}}
}
