% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{mig_loglik_hessian}
\alias{mig_loglik_hessian}
\title{Hessian of the MIG log likelihood with respect to data}
\usage{
mig_loglik_hessian(x, beta, xi, Omega)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of quantiles}

\item{beta}{\code{d} vector \eqn{\boldsymbol{\beta}} defining the half-space through \eqn{\boldsymbol{\beta}^{\top}\boldsymbol{\xi}>0}}

\item{xi}{\code{d} vector of location parameters \eqn{\boldsymbol{\xi}}, giving the expected value}

\item{Omega}{\code{d} by \code{d} positive definite scale matrix \eqn{\boldsymbol{\Omega}}}
}
\value{
a \code{d} by \code{d} matrix of second derivatives if \code{x} has length \code{d},
else an \code{n} by \code{d} by \code{d} array if \code{x} is an \code{n} by \code{d} matrix
}
\description{
This function returns the hessian, i.e., the matrix of
second derivatives of the log likelihood with respect to the
argument \code{x}.
}
\keyword{internal}
