% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_comp2.R
\name{multi_comp2}
\alias{multi_comp2}
\title{Multiplicative component descriptions of origin-destination flow tables based on total reference coding system.}
\usage{
multi_comp2(m)
}
\arguments{
\item{m}{\code{matrix} of migration flows}
}
\value{
\code{matrix} of multiplicative components of \code{m}. When output is an array the total for each table of origin-destination flows is used.
}
\description{
Multiplicative component descriptions of origin-destination flow tables based on total reference coding system.
}
\examples{
r <- LETTERS[1:2]
m0 <- array(c(5, 1, 2, 7, 4, 2, 5, 9), dim = c(2, 2, 2),
            dimnames = list(orig = r, dest = r, type = c("ILL", "HEALTHY")))
addmargins(m0)
multi_comp2(m = m0)
}
\references{
Rogers, A., Willekens, F., Little, J., & Raymer, J. (2002). Describing migration spatial structure. Papers in Regional Science, 81(1), 29–48. https://doi.org/10.1007/s101100100090

Raymer, J., Bonaguidi, A., & Valentini, A. (2006). Describing and projecting the age and spatial structures of interregional migration in Italy. Population, Space and Place, 12(5), 371–388. https://doi.org/10.1002/psp.414
}
