#' Early blood development: single cell binary gene expression data
#'
#' Binarized expression data of 33 transcription factors involved
#' in early differentiation of primitive erythroid and endothelial
#' cells (3934 cells).
#'
#' @docType data
#' @name hematoData
#' @usage data(hematoData)
#' @format A data.frame object.
#'
#' @keywords datasets
#'
#' @references Moignard et al. (2015) Nat Biotechnol 33(3):269-76
#' (\href{https://pubmed.ncbi.nlm.nih.gov/25355519/}{PubMed link})
#'
#' @keywords data
NULL



#' Genomic and ploidy alterations in breast tumors
#'
#' The dataset contains 807 samples without predisposing Brca1/2 germline mutations
#' and includes 204 somatic mutations (from whole exome sequencing) and expression
#'  level information for 91 genes.
#'
#' @docType data
#' @name cosmicCancer
#' @usage data(cosmicCancer)
#'
#' @format A data.frame object.
#'
#' @keywords datasets
#'
#' @references Forbes SA, Beare D, Gunasekaran P, Leung K, Bindal N, et al. (2015)
#' Nucleic Acids Res 43:D805–D811. (\href{https://pubmed.ncbi.nlm.nih.gov/25355519/}{PubMed link})
#'
#' @keywords data
NULL


#' Genomic and ploidy alterations in breast tumors
#'
#' The dataset contains 807 samples without predisposing Brca1/2 germline mutations
#' and includes 204 somatic mutations (from whole exome sequencing) and expression
#'  level information for 91 genes, category order file.
#'
#' @docType data
#' @name cosmicCancer_stateOrder
#' @usage data(cosmicCancer_stateOrder)
#'
#' @format A data.frame object.
#'
#' @keywords datasets
#'
#' @references Forbes SA, Beare D, Gunasekaran P, Leung K, Bindal N, et al. (2015)
#' Nucleic Acids Res 43:D805–D811. (\href{https://pubmed.ncbi.nlm.nih.gov/25355519/}{PubMed link})
#'
#' @keywords data
NULL


#' Covid cases
#'
#' Demo dataset of chronological series to be used in temporal mode of miic.
#' Evolution of Covid cases on a subset of EU countries from 12/31/2019 to 06/18/2020.
#' Source of the data : European Centre for Disease Prevention and Control.
#'
#' @docType data
#' @usage data(covidCases)
#' @format A data.frame object.
#' @keywords datasets
#' @name covidCases
#' @references ECDC (\href{https://www.ecdc.europa.eu/en/publications-data/download-todays-data-geographic-distribution-covid-19-cases-worldwide}{ECDC link})
#'
#' @keywords data
NULL

