% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omisvm.R
\name{predict.omisvm}
\alias{predict.omisvm}
\title{Predict method for \code{omisvm} object}
\usage{
\method{predict}{omisvm}(
  object,
  new_data,
  type = c("class", "raw"),
  layer = c("bag", "instance"),
  new_bags = "bag_name",
  ...
)
}
\arguments{
\item{object}{An object of class \code{omisvm}}

\item{new_data}{A data frame to predict from. This needs to have all of the
features that the data was originally fitted with.}

\item{type}{If \code{'class'}, return predicted values with threshold of 0 as
-1 or +1.  If \code{'raw'}, return the raw predicted scores.}

\item{layer}{If \code{'bag'}, return predictions at the bag level.  If
\code{'instance'}, return predictions at the instance level.}

\item{new_bags}{A character or character vector.  Can specify a singular
character that provides the column name for the bag names in \code{new_data}
(default \code{'bag_name'}).  Can also specify a vector of length
\code{nrow(new_data)} that has bag name for each row.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A tibble with \code{nrow(new_data)} rows.  If \code{type = 'class'}, the tibble
will have a column \code{.pred_class}.  If \code{type = 'raw'}, the tibble will have
a column \code{.pred}.
}
\description{
Predict method for \code{omisvm} object
}
\details{
When the object was fitted using the \code{formula} method, then the parameters
\code{new_bags} and \code{new_instances} are not necessary, as long as the names match
the original function call.
}
\examples{
if (require(gurobi)) {
  data("ordmvnorm")
  x <- ordmvnorm[, 3:7]
  y <- ordmvnorm$bag_label
  bags <- ordmvnorm$bag_name

  mdl1 <- omisvm(x, y, bags, weights = NULL)

  # summarize predictions at the bag layer
  library(dplyr)
  df1 <- bind_cols(y = y, bags = bags, as.data.frame(x))
  df1 \%>\%
    bind_cols(predict(mdl1, df1, new_bags = bags, type = "class")) \%>\%
    bind_cols(predict(mdl1, df1, new_bags = bags, type = "raw")) \%>\%
    distinct(y, bags, .pred_class, .pred)
}

}
\seealso{
\code{\link[=omisvm]{omisvm()}} for fitting the \code{omisvm} object.
}
\author{
Sean Kent
}
