% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svor_exc.R
\name{predict.svor_exc}
\alias{predict.svor_exc}
\title{Predict method for \code{svor_exc} object}
\usage{
\method{predict}{svor_exc}(
  object,
  new_data,
  type = c("class", "raw"),
  layer = c("instance", "bag"),
  new_bags = "bag_name",
  ...
)
}
\arguments{
\item{object}{An object of class \code{svor_exc}.}

\item{new_data}{A data frame to predict from. This needs to have all of the
features that the data was originally fitted with.}

\item{type}{If \code{'class'}, return predicted values with threshold of 0 as
-1 or +1.  If \code{'raw'}, return the raw predicted scores.}

\item{layer}{If \code{'bag'}, return predictions at the bag level.  If
\code{'instance'}, return predictions at the instance level.}

\item{new_bags}{A character or character vector.  Can specify a singular
character that provides the column name for the bag names in \code{new_data}
(default \code{'bag_name'}).  Can also specify a vector of length
\code{nrow(new_data)} that has bag name for each row.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A tibble with \code{nrow(new_data)} rows.  If \code{type = 'class'}, the tibble
will have a column \code{.pred_class}.  If \code{type = 'raw'}, the tibble will have
a column \code{.pred}.
}
\description{
Predict method for \code{svor_exc} object
}
\details{
When the object was fitted using the \code{formula} method, then the parameter
\code{new_bags} is not necessary, as long as the names match
the original function call.
}
\examples{
data("ordmvnorm")
x <- ordmvnorm[, 3:7]
y <- attr(ordmvnorm, "instance_label")

mdl1 <- svor_exc(x, y)
predict(mdl1, x)
predict(mdl1, x, type = "raw")

}
\seealso{
\code{\link[=svor_exc]{svor_exc()}} for fitting the \code{svor_exc} object.
}
\author{
Sean Kent
}
