% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{miniContentPanel}
\alias{miniContentPanel}
\title{Create a content panel}
\usage{
miniContentPanel(..., padding = 15, scrollable = TRUE)
}
\arguments{
\item{...}{UI objects to be contained in the \code{miniContentPanel}. A
single htmlwidget or \code{\link[shiny:plotOutput]{shiny::plotOutput()}} with
\code{height="100\%"} works well, as do
\code{\link[shiny:fillRow]{shiny::fillRow()}}/\code{\link[shiny:fillRow]{shiny::fillCol()}}.}

\item{padding}{Amount of padding to apply. Can be numeric (in pixels) or
character (e.g. \code{"3em"}).}

\item{scrollable}{If \code{TRUE}, then content large enough to overflow the
\code{miniContentPanel} will make scrollbars appear.}
}
\description{
Creates a panel for containing arbitrary content within a flex box container.
This is mainly useful within \code{\link[=miniPage]{miniPage()}} or a
\code{\link[=miniTabPanel]{miniTabPanel()}}. You can use \code{miniContentPanel} to introduce
padding and/or scrolling, but even if padding/scrolling aren't needed, it's a
good idea to wrap your custom content into \code{miniContentPanel} as it
fixes some odd behavior with percentage-based heights.
}
\examples{
library(shiny)

miniContentPanel(padding = 0,
  plotOutput("plot", height = "100\%")
)

}
\seealso{
For more information, see the
\href{http://shiny.rstudio.com/articles/gadget-ui.html}{Designing Gadget UI}
article on shiny.rstudio.com.
}
