# Copyright 2024. Jaime Salvador
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this proprietary software and associated documentation files (the "Software"),
# to use, publish, or distribute copies of the Software, and to permit persons to
# whom the Software is furnished to do so.
#
# Any other use, including modifying, adapting, reverse engineering, decompiling,
# or disassembling, is not permitted.
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

#' Environment for Outputs Tables
#'
#' This environment is created to store the outputs generated by a Redatam program
#' execution.
#' The environment contains TABLES (Redatam outputs) generated from FREQ, AREALIST,
#'  MATOP, TABLIST commands.
#' You can't modify objects contained in this environment.
#'
#' @export
#' @examples
#' \dontrun{
#' library(minired)
#' dic<-redatam_open("c:/nmir/nmiresp.rxdb")
#' df<-redatam_query(dic,"tbl1<-freq person.sexo")
#' # Accessing the tbl1 object from environment
#' redatam::outputs$tbl1
#' # Accessing the output from Global Environment
#' print(tbl1)
#' }
#'
"outputs"
