% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRIME.R
\name{PRIME}
\alias{PRIME}
\title{Partial Replacement IMputation Estimation (PRIME) for Missing Covariates}
\usage{
PRIME(
  Y,
  X,
  method = c("PRIME", "PRIME-MA"),
  model_structure = NULL,
  intercept = FALSE,
  bw = NULL,
  k_type = NULL,
  weight_type = c("CP", "CV"),
  L = NULL
)
}
\arguments{
\item{Y}{a numeric vector, the response variable.}

\item{X}{a numeric matrix that may include NAs (missing), the covariate matrix.}

\item{method}{Users can choose \code{PRIME} or \code{PRIME-MA}. If \code{method="PRIME"}, users must provide the model structure (nonlinear part index) in the input argument; If \code{method=="PRIME-MA"}, then the program automatically applies model averaging methods to reduce  reduce the loss of misspecification of models without model structure.}

\item{model_structure}{only available when \code{method="PRIME"}. It is a 0/1 index vector representing whether each variable is linear/nonlinear in the partially linear model. For details see Example section.}

\item{intercept}{logical. if \code{TRUE}, an intercept is included in the basis; default is \code{FALSE}.}

\item{bw}{a positive value, specify the bandwidth in estimating missing values, default as \code{NULL}. When \code{bw=NULL}, it is automatically selected by Silverman's rule of thumb method.}

\item{k_type}{an optional character string, specify the type of kernel used in iterative estimating algorithm and support 'epk', 'biweight', 'triangle', 'gaussian', 'triweight', 'tricube', 'cosine', 'uniform' in current version, default as 'gaussian'.}

\item{weight_type}{Options for computing weights for \code{PRIME-MA} method. Users can choose among \code{CP} and \code{CV}.}

\item{L}{an optional positive integer, degree of the piecewise polynomial, default as '3' for cubic splines.}
}
\value{
an object of class "prime" is a list containing at least the following components:
\item{coef}{only available when \code{method="PRIME"}. A vector of coefficients of partially linear model.}
\item{beta}{only available when \code{method="PRIME"}. A vector of coefficients of linear parts in partially linear model.}
\item{Cmat}{only available when \code{method="PRIME-MA"}. A list of coefficients of candidate partially linear models.}
\item{weight}{only available when \code{method="PRIME-MA"}. The weights for candidate models, each candidate model involves one nonlinear part and others are linear parts.}
}
\description{
partial replacement imputation estimation conducts imputation and regression simultaneously for missing covariates in additive partially linear model.
}
\examples{
data(PRIME_SimuData)
X = PRIME_SimuData[,-1]
Y = PRIME_SimuData[,1]
model_structure <- c(rep(0,5),1,1,1)

# estimation
result <- PRIME(Y, X, method = 'PRIME', model_structure, intercept = FALSE, weight_type = 'CV')
result$coef
result$beta
}
