% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLRgen.R
\name{simLRgen}
\alias{simLRgen}
\title{Simulate likelihoods ratio (LRs) based on genetic data: a function for obtaining expected LRs under relatedness and unrelatedness kinship hypothesis.}
\usage{
simLRgen(reference, missing, numsims, seed, numCores = 1)
}
\arguments{
\item{reference}{Reference pedigree. It could be an input from read_fam() function or a pedigree built with pedtools.}

\item{missing}{Missing person ID/label indicated in the pedigree.}

\item{numsims}{Number of simulations performed.}

\item{seed}{Select a seed for simulations. If it is defined, results will be reproducible. Suggested, seed = 123}

\item{numCores}{Enables parallelization}
}
\value{
An object of class data.frame with LRs obtained for both hypothesis, Unrelated where POI is not MP or Related where POI is MP.
}
\description{
Simulate likelihoods ratio (LRs) based on genetic data: a function for obtaining expected LRs under relatedness and unrelatedness kinship hypothesis.
}
\examples{
library(forrel)
x = linearPed(2)
plot(x)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x = profileSim(x, N = 1, ids = 2)
datasim = simLRgen(x, missing = 5, 10, 123)
}
