% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_simulated.R
\name{impute_simulated}
\alias{impute_simulated}
\title{Imputation algorithm tester on simulated data}
\usage{
impute_simulated(
  rownum,
  colnum,
  cormat,
  n.iter = 10,
  MD_pattern,
  NA_fraction,
  min_PDM = 10,
  assumed_pattern = NA
)
}
\arguments{
\item{rownum}{Number of rows (samples) in the original dataframe (Rows output from the \code{\link{get_data}} function)}

\item{colnum}{Number of rows (variables) in the original dataframe (Columns output from the \code{\link{get_data}} function)}

\item{cormat}{Correlation matrix of the original dataframe (Corr_matrix output from the \code{\link{get_data}} function)}

\item{n.iter}{Number of iterations to perform with default 10.}

\item{MD_pattern}{Missing data pattern in the original dataset (MD_Pattern output from the \code{\link{get_data}} function)}

\item{NA_fraction}{Fraction of missingness in the original dataset (Fraction_missingness output from the \code{\link{get_data}} function)}

\item{min_PDM}{All patterns with number of observations less than this number will be removed from the missing data generation. This argument is necessary to be carefully set, as the function will fail or generate erroneous missing data patterns with very complicated missing data patterns. The default is 10, but for large datasets this number needs to be set higher to avoid errors.}

\item{assumed_pattern}{Vector of missingness types (must be same length as missingness fraction per variable). If this input is specified, the function will spike in missing datapoints in a MAP pattern as well.}
}
\value{
\item{Imputation_metrics_raw}{Raw RMSE, MAE, KS and computation time values per method, per missingness pattern, per iteration)}
\item{Imputation_metrics_means}{RMSE, MAE, KS and computation time means per method and missingness pattern}
\item{Plot_TIME}{Boxplot of computation time values per missing data imputation algorithm}
\item{Plot_RMSE}{Faceted boxplot of RMSE values per missingness pattern and missing data imputation algorithm}
\item{Plot_MAE}{Faceted boxplot of MAE values per missingness pattern and missing data imputation algorithm}
\item{Plot_KS}{Faceted boxplot of KS values per missingness pattern and missing data imputation algorithm}
}
\description{
\code{\link{impute_simulated}} tests the imputation quality of all missing data imputation algorithms on matrices with various missing data patterns, using various metrics
}
\details{
This function tests the imputation accuracy of the a curated list of missing data imputation algorithms (16 algorithms at the moment) by comparing the
original simulated matrix with no missingness and the imputed matrices generated by the algorithm using the matrices with
MCAR, MAR, MNAR and (optionally) MAP missingness patterns. The function calculates root-mean-square error (RMSE), mean absolute error (MAE),
Kolmogorov-Smirnov test statistics D (KS) between the imputed datapoints and the original datapoints (that were subsequently set to missing)
for each missing data imputation algorithm. The function will calculate average computation time per method as well. The function will
automatically detect whether there is a MAP matrix in the list and calculate metrics for all matrices provided in the list. Important! All statistics
output by this function are calculated for ALL missing values across the dataset, not by variable.
}
\examples{
## in case there is no assumed missingness pattern per variable
# wrap <- impute_simulated(rownum = metadata$Rows,
#        colnum = metadata$Columns,
#        cormat = metadata$Corr_matrix,
#        MD_pattern = metadata$MD_Pattern,
#        NA_fraction = metadata$Fraction_missingness,
#        min_PDM = 10,
#        n.iter = 50)

## in case there is a pre-defined assumed pattern
# wrap <- impute_simulated(rownum = metadata$Rows,
#        colnum = metadata$Columns,
#        cormat = metadata$Corr_matrix,
#        MD_pattern = metadata$MD_Pattern,
#        NA_fraction = metadata$Fraction_missingness,
#        min_PDM = 10,
#        assumed_pattern = c('MAR','MAR','MCAR','MCAR',
#                          'MNAR','MCAR','MAR','MNAR',
#                          'MCAR','MNAR','MCAR'),
#        n.iter = 50)

}
