% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missDiag.R
\name{missDiag}
\alias{missDiag}
\title{Comparing Observed and Imputed Values under MAR and MCAR}
\usage{
missDiag(
  original,
  imputed,
  formula = NULL,
  skip_n = 25,
  scale = FALSE,
  adjust = "ebal",
  use_imputed_cov = TRUE,
  convert = c("numeric"),
  categories = 3,
  verbose = 0,
  output_diag = FALSE,
  ebal_param = param_ebal(),
  sbw_param = param_sbw(),
  cobalt_param = param_cobalt()
)
}
\arguments{
\item{original}{data frame with missing values.}

\item{imputed}{an imputed data frame, a list of imputed data frames or
a \code{mids} object from the \code{\link[mice:mice]{mice::mice()}} package.}

\item{formula}{two-sided formula with the variables to compute discrepancy
statistics (right-hand side) and variables to balance (left-hand side).}

\item{skip_n}{skip variables with fewer than \code{skip_n} missing values.}

\item{scale}{scale the design matrix?}

\item{adjust}{either 'none', 'sbw' or 'ebal'.}

\item{use_imputed_cov}{use imputed covariates?}

\item{convert}{vector of variable types to bin before coercion
(ignored if \code{use_imputed_cov=TRUE}).}

\item{categories}{how many bins (ignored if \code{use_imputed_cov=TRUE}).}

\item{verbose}{one of three levels (0,1 or 2).}

\item{output_diag}{add covariate balance statistics to output?}

\item{ebal_param}{list of parameters passed to \code{ebal}.}

\item{sbw_param}{list of parameters passed to \code{sbw}.}

\item{cobalt_param}{list of parameters passed to \code{cobalt}.}
}
\value{
A single \code{data.frame} with the results for
each imputed dataset and all lhs variables.

If \code{output_diag=FALSE}, the dataset only includes
the discrepancy statistics comparing y's observed values and
imputed values.

If y is continuous, there will be exactly one row per imputed
dataset. The discrepancy statistics are reported in the
respective columns. For a categorical y cobalt
computes discrepancy statistics for all K categories which means
that there will be K rows for each imputed dataset in the
output. The label for each category is listed in \code{vname}.

If the default settings are adopted, the dataset includes
the following discrepancy statistics for continuous variables:

\itemize{
\item \code{diff_adj}: Standardized mean difference
\item \code{v_ratio_adj}: Variance ratio
\item \code{ks_adj}: Kolmogorov–Smirnov statistic
\item \code{ovl_adj}: 1-Overlap coefficient
}

No variance ratio is reported for categorical variables.

If \code{output_diag=TRUE}, the dataset also includes
the balance statistics for all K covariates.

These balance statistics are useful to diagnose if the fitted
weights are successful in balancing the covariate distribution.

For these diagnostics the column \code{vname} lists
the covariate name (for continuous variables) or the
covariate category (for categorical variables).
}
\description{
Function to compute discrepancy statistics comparing the (reweighted)
density of imputed and observed values. To compute the weights balancing
covariates that are part of the missing data mechanism, the function
relies on either entropy balancing or stable balancing weights.
}
\details{
Let y be a variable with observed and imputed values and let m be
a corresponding indicator if a value in y is observed (0) or imputed (1).
We use X to denote all K covariates and x_k as the k^th covariate.

By default, \code{missDiag} computes discrepancy statistics (balance
statistics) comparing the distribution of observed and imputed values,
ie. comparing f(y|m=1) vs. f(y|m=0). The distribution are expected
to be equal under MCAR.

If the data are missing at random (MAR), set \code{adjust="ebal"}
or \code{adjust="sbw"}, to construct weights to balance the
covariate distribution X before computing the discrepancy statistics.

The left-hand side (lhs) of the \code{formula} gives the name of y while the
right-hand side (rhs) defines the covariates X to balance under MAR.
Rhs variables are transformed into a numeric matrix via the
\code{\link[stats:model.matrix]{stats::model.matrix()}} function. Therefore  factor and string variables
are dummy encoded and functional transformations such as \code{log()}
are applied.

To run \code{missDiag} on many y variables sequentially, supply a list
of formulas or name all y variables on the lhs separating each variable
with a "|", e.g. \code{y1 | y2 ~ x1 + ... + xK}.

If \code{formula=NULL}, \code{missDiag} runs on all variables with at
least \code{n_skip} missing values in \code{original}. Weights are
constructed such that all X covariates are balanced
(if \code{adjust!='none'}).

If \code{use_imputed_cov=FALSE}, all imputed values in the covariates X
are deleted, variables are coerced to factor variables with missing
values encoded as one category. Numerical variables are binned by quantiles
before coercion. Use the parameter \code{categories} to define the
number of bins. By default only variables of class "numeric" are binned.
Use \code{convert = c("numeric", "integer")} to also bin integer
variables before coercion to factor variables.

To balance the covariates, \code{missDiag} computes weights using either
the \code{\link[ebal:ebalance]{ebal::ebalance()}} function or the \code{\link[sbw:sbw]{sbw::sbw()}} function. These
two packages have to be installed separately by the user.

To pass parameters to the \code{\link[sbw:sbw]{sbw::sbw()}} or \code{\link[ebal:ebalance]{ebal::ebalance()}} use the
functions \code{\link[=param_sbw]{param_sbw()}} and \code{\link[=param_sbw]{param_sbw()}} to generate valid parameter lists
and pass these lists via the parameters \code{sbw_param} or
\code{ebal_param}.

To display information about the computations set verbose to the value
1 (some information) or 2 (more information when constructing weights).

To compute the discrepancy statistics, \code{missDiag} relies on the function
\code{\link[cobalt:bal.tab]{cobalt::bal.tab()}} from the cobalt package. To pass parameters to this
function use \code{\link[=param_cobalt]{param_cobalt()}} to generate a valid parameter list and
pass this list via the parameter \code{cobalt_param}.
}
\examples{

# Compare random value imputation 
# with predictive mean imputation 
# under MCAR

diag_rng <- missDiag( 
 original=anes08, 
 imputed=anes08_rng, 
 verbose = 1,
 adjust = 'none',
 formula = time ~ .)

diag_pmm <- missDiag( 
 original=anes08, 
 imputed=anes08_pmm, 
 verbose = 1,
 adjust = 'none',
 formula = time ~ .)

# SMD: 

 mean(diag_pmm$diff_adj)
 mean(diag_rng$diff_adj)

# log(Variance ratio)
 mean(log(diag_pmm$v_ratio_adj))
 mean(log(diag_rng$v_ratio_adj))

# KS
 mean(diag_pmm$ks_adj)
 mean(diag_rng$ks_adj)

# 1-OVL
 mean(diag_pmm$ovl_adj)
 mean(diag_rng$ovl_adj)



}
\references{
Moritz Marbach. 2021. Choosing Imputation Models.

José R Zubizarreta. 2015. Stable Weights that Balance Covariates
for Estimation with Incomplete Outcome Data, Journal of the American
Statistical Association, 110(511): 910-922.

Jens Hainmueller. 2012. Entropy Balancing for Causal Effects: A
Multivariate Reweighting Method to Produce Balanced Samples in
Observational Studies, Political Analysis 20(1): 25–46.
}
