% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_NA.R
\name{count_NA}
\alias{count_NA}
\title{Count the number of \code{NA}s}
\usage{
count_NA(x, type = "default")
}
\arguments{
\item{x}{a vector, matrix or data frame, in which \code{NA} values are counted}

\item{type}{How to count the \code{NA} values. Possible choices:
\itemize{
\item "default": If \code{x} is a matrix or a data frame, the number of missing
values per column is returned. If \code{x} is something else, the total number
of missing values in \code{x} is returned.
\item "all": The number of all missing values in \code{x} is returned.
\item "cols": The number of missing values per column is returned.
\item "rows": The number of missing values per row is returned.
}}
}
\value{
The number of missing values.
}
\description{
Count the number of \code{NA} values in a vector, matrix or data frame
}
\examples{
count_NA(c(1, NA, 3, NA, 5, NA))
test_df <- data.frame(X1 = rep(c(1, NA), 5), X2 = c(1:9, NA))
count_NA(test_df)
count_NA(test_df, "cols") # the default
count_NA(test_df, "rows")
count_NA(test_df, "all")
}
