% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.mixfitEM.R
\name{density.mixfitEM}
\alias{density.mixfitEM}
\title{The Density of Finite Mixture Models}
\usage{
\method{density}{mixfitEM}(x, at, smoothness = 512, cut = 3.8, ...)
}
\arguments{
\item{x}{an object of class \code{mixfitEM}}

\item{at}{a scalar or a numeric vector of locations where densities are calculated}

\item{smoothness}{a positive integer controlling the smoothness of the density curve (default 512).
The higher this value is, the more locations of the mixture model the density is calculated.}

\item{cut}{the number of standard deviations away the density is to be computed (default 3.8)}

\item{...}{other arguments}
}
\value{
This function returns a list of class \code{densityEM}, which contains the following
items.
\item{x}{a scalar or a numeric vector of locations where densities are calculated.}
\item{y}{a vector of the densities of the mixture model at the corresponding locations in \code{x}}
\item{comp}{a matrix with columns representing the densities of each component in the mixture model at the corresponding locations in \code{x}}
}
\description{
This function calculates the probability density of a finite mixture model.
}
\details{
The function \code{density.mixfitEM} is the method of the generic function
\code{density} for the class \code{mixfitEM}.
}
\examples{
set.seed(102)
x <- rmixnormal(200, c(0.5, 0.5), c(2, 5), c(1, 0.7))
fit1 <- mixfit(x, ncomp = 2)
d1 = density(fit1)
d2 = density(fit1, at = 0)

}
\seealso{
\code{\link{mixfit}}
}
