% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_mixture.R
\name{fs_mixture}
\alias{fs_mixture}
\title{Fraser-Suzuki mixture model}
\usage{
fs_mixture(temp, height_1, skew_1, position_1, width_1, height_2, skew_2,
  position_2, width_2, height_3, skew_3, position_3, width_3,
  height_0 = NULL, skew_0 = NULL, position_0 = NULL,
  width_0 = NULL)
}
\arguments{
\item{temp}{temperature values}

\item{height_1}{height value for hemicellulose}

\item{skew_1}{shape value for hemicellulose}

\item{position_1}{position value for hemicellulose}

\item{width_1}{width value for hemicellulose}

\item{height_2}{height value for cellulose}

\item{skew_2}{shape value for cellulose}

\item{position_2}{position value for cellulose}

\item{width_2}{width value for cellulose}

\item{height_3}{height value for lignin}

\item{skew_3}{shape value for lignin}

\item{position_3}{position value for lignin}

\item{width_3}{width value for lignin}

\item{height_0}{height value for second hemicellulose curve, if present}

\item{skew_0}{shape value for second hemicellulose curve, if present}

\item{position_0}{position value for second hemicellulose curve, if present}

\item{width_0}{width value for second hemicellulose curve, if present}
}
\value{
Fraser-Suzuki model output
}
\description{
Fraser-Suzuki mixture model
}
\examples{
temp <- 150:600
fs_mixture_output <- fs_mixture(temp,
height_1 = 0.003, skew_1 = -0.15, position_1 = 250, width_1 = 50,
height_2 = 0.006, skew_2 = -0.15, position_2 = 320, width_2 = 30,
height_3 = 0.001, skew_3 = -0.15, position_3 = 390, width_3 = 200)

}
