% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tex.R
\name{summary_tex}
\alias{summary_tex}
\title{Return tex formatted output of a model summary. If an output_file parameter is provided, save the object to that location}
\usage{
summary_tex(model_summary, output_file)
}
\arguments{
\item{model_summary}{A summary of an estimated Model}

\item{output_file}{Where to save the tex representation}
}
\value{
Formatted texreg object containing the latex table suitable for a research paper. See \link[texreg]{createTexreg}
}
\description{
The returned object can be passed to \code{texreg}'s formatting functions (see 'Examples').
}
\examples{
\donttest{
  data("Train", package="mlogit")
  Train$ID <- Train$id
  Train$CHOICE <- as.numeric(Train$choice)
  
  mnl_test <- "
	U_A = @B_price * $price_A / 1000 + @B_time * $time_A / 60;
	U_B = @asc + @B_price * $price_B / 1000 + @B_timeB * $time_B / 60;
	"
  
  model_spec <- mixl::specify_model(mnl_test, Train, disable_multicore=T)
  
  #only take starting values that are needed
  est <- stats::setNames(c(1, 1,1,1), c("asc", "B_price", "B_time", "B_timeB"))
  availabilities <- mixl::generate_default_availabilities(
    Train, model_spec$num_utility_functions
  )
  
  model2 <- mixl::estimate(model_spec, est, Train, availabilities = availabilities)
  print(model2)
  
  tex <- summary_tex(model2)
  texreg::screenreg(tex, digits = 5)
}
}
