% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_diagnostic_functions.R
\name{vcov.mixpoissonreg}
\alias{vcov.mixpoissonreg}
\title{Calculate Variance-Covariance Matrix for \code{mixpoissonreg} Objects}
\usage{
\method{vcov}{mixpoissonreg}(object, parameters = c("all", "mean", "precision"), ...)
}
\arguments{
\item{object}{an object of class "mixpoissonreg" containing results from the fitted model.}

\item{parameters}{a string to determine which coefficients should be extracted: 'all' extracts all coefficients, 'mean' extracts the coefficients of the mean parameters and 'precision' extracts coefficients of the precision parameters.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A matrix containing the covariance matrix of a \emph{mixpoissonreg} object.
}
\description{
Returns the variance-covariance matrix of the parameters for fitted mixed Poisson regression models. The \code{parameters} argument
indicates for which parameters the variance-covariance matrix should be computed, namely, 'mean' for mean-relatex parameters or 'precision' for precision-related parameters.
}
\examples{

daysabs_prog <- mixpoissonreg(daysabs ~ prog, data = Attendance)
vcov(daysabs_prog)

}
\seealso{
\code{\link{coef.mixpoissonreg}}
}
