% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test.R
\name{chisq_test}
\alias{chisq_test}
\title{Perform Chi-Square Test on Sets of Transmission Trees}
\usage{
chisq_test(..., method = c("chisq", "fisher"), test_args = list())
}
\arguments{
\item{...}{Two or more sets of transmission trees. Each set is a list of data frames with columns \code{from} and \code{to}.}

\item{method}{Test to use: \code{"chisq"} for Chi-Square or \code{"fisher"} for Fisher's Exact Test. Default is \code{"chisq"}.}

\item{test_args}{A list of additional arguments for \code{stats::chisq.test} or \code{stats::fisher.test}. Default is an empty list.}
}
\value{
An \code{htest} object with the test results.
}
\description{
Tests whether the distribution of infector-infectee pairs differs between sets of transmission trees.
}
\examples{
set.seed(1)
# No difference in the sets
setA <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 2, stochastic = TRUE)
),
simplify = FALSE
)
setB <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 2, stochastic = TRUE)
),
simplify = FALSE
)
chisq_test(setA, setB)

# Difference in the sets
setC <- replicate(10, igraph::as_long_data_frame(
  make_tree(n_cases = 10, R = 4, stochastic = TRUE)
),
simplify = FALSE
)
chisq_test(setA, setB, setC)
}
